/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors;

import com.linkedin.feathr.core.config.producer.anchors.FeatureConfig;
import com.linkedin.feathr.core.config.producer.anchors.TimeWindowFeatureConfig;
import com.linkedin.feathr.core.configbuilder.ConfigBuilderException;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors.FeatureConfigBuilder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

abstract class BaseAnchorConfigBuilder {
    private static final Logger logger = Logger.getLogger(BaseAnchorConfigBuilder.class);

    BaseAnchorConfigBuilder() {
    }

    public static Map<String, FeatureConfig> getFeatures(Config anchorConfig) {
        Map<String, FeatureConfig> features;
        logger.debug((Object)("Building FeatureConfig objects in anchor " + anchorConfig));
        ConfigValue value = anchorConfig.getValue("features");
        ConfigValueType valueType = value.valueType();
        switch (valueType) {
            case LIST: {
                List featureNames = anchorConfig.getStringList("features");
                features = FeatureConfigBuilder.build(featureNames);
                break;
            }
            case OBJECT: {
                Config featuresConfig = anchorConfig.getConfig("features");
                features = FeatureConfigBuilder.build(featuresConfig);
                break;
            }
            default: {
                throw new ConfigBuilderException("Expected features value type List or Object, got " + valueType);
            }
        }
        return features;
    }

    static boolean hasTimeWindowFeatureConfig(Map<String, FeatureConfig> featureConfigMap) {
        FeatureConfig featureConfig = featureConfigMap.values().iterator().next();
        return featureConfig instanceof TimeWindowFeatureConfig;
    }
}

