/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors;

import com.linkedin.feathr.core.config.producer.ExprType;
import com.linkedin.feathr.core.config.producer.anchors.ExpressionBasedFeatureConfig;
import com.linkedin.feathr.core.config.producer.common.FeatureTypeConfig;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.common.FeatureTypeConfigBuilder;
import com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExpressionBasedFeatureConfigBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ExpressionBasedFeatureConfigBuilder.class);

    private ExpressionBasedFeatureConfigBuilder() {
    }

    public static ExpressionBasedFeatureConfig build(String featureName, Config featureConfig) {
        ExprType exprType;
        String expr;
        if (featureConfig.hasPath("def.sqlExpr")) {
            expr = featureConfig.getString("def.sqlExpr");
            exprType = ExprType.SQL;
        } else if (featureConfig.hasPath("def")) {
            expr = featureConfig.getString("def");
            exprType = ExprType.MVEL;
        } else {
            throw new RuntimeException("ExpressionBasedFeatureConfig should have def.sqlExpr field or def field but found none in : " + featureConfig);
        }
        FeatureTypeConfig featureTypeConfig = FeatureTypeConfigBuilder.build(featureConfig);
        String defaultValue = featureConfig.hasPath("default") ? featureConfig.getValue("default").render() : null;
        ExpressionBasedFeatureConfig configObj = new ExpressionBasedFeatureConfig(expr, exprType, defaultValue, featureTypeConfig);
        logger.trace("Built ExpressionBasedFeatureConfig for feature" + featureName);
        return configObj;
    }
}

