/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors;

import com.linkedin.feathr.core.config.producer.anchors.ExtractorBasedFeatureConfig;
import com.linkedin.feathr.core.config.producer.common.FeatureTypeConfig;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.common.FeatureTypeConfigBuilder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExtractorBasedFeatureConfigBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ExtractorBasedFeatureConfigBuilder.class);

    private ExtractorBasedFeatureConfigBuilder() {
    }

    public static ExtractorBasedFeatureConfig build(String featureName, Config featureConfig) {
        FeatureTypeConfig featureTypeConfig = FeatureTypeConfigBuilder.build(featureConfig);
        String defaultValue = featureConfig.hasPath("default") ? featureConfig.getValue("default").render() : null;
        Map<String, String> parameters = featureConfig.hasPath("parameters") ? ExtractorBasedFeatureConfigBuilder.getParameters(featureConfig) : Collections.emptyMap();
        logger.trace("Built ExtractorBasedFeatureConfig for feature" + featureName);
        return new ExtractorBasedFeatureConfig(featureName, featureTypeConfig, defaultValue, parameters);
    }

    public static Map<String, String> getParameters(Config anchorConfig) {
        logger.debug("Building Parameters objects in anchor " + anchorConfig);
        Config config = anchorConfig.getConfig("parameters");
        ConfigObject featuresConfigObj = config.root();
        return featuresConfigObj.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ConfigValue)entry.getValue()).render(ConfigRenderOptions.concise())));
    }
}

