/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors;

import com.linkedin.feathr.core.config.producer.anchors.ExtractorBasedFeatureConfig;
import com.linkedin.feathr.core.config.producer.anchors.FeatureConfig;
import com.linkedin.feathr.core.configbuilder.ConfigBuilderException;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors.ExpressionBasedFeatureConfigBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors.ExtractorBasedFeatureConfigBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors.TimeWindowFeatureConfigBuilder;
import com.linkedin.feathr.core.utils.Utils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FeatureConfigBuilder {
    private static final Logger logger = LoggerFactory.getLogger(FeatureConfigBuilder.class);

    private FeatureConfigBuilder() {
    }

    public static Map<String, FeatureConfig> build(Config featuresConfig) {
        logger.debug("Building FeatureConfig object for featuresConfig " + featuresConfig);
        ConfigObject featuresConfigObj = featuresConfig.root();
        Set featureNames = featuresConfigObj.keySet();
        logger.trace("Found feature names:" + Utils.string(featureNames));
        Map<String, FeatureConfig> configObjMap = featureNames.stream().collect(Collectors.toMap(Function.identity(), fName -> FeatureConfigBuilder.build(featuresConfig, fName)));
        logger.debug("Built all FeatureConfig objects");
        return configObjMap;
    }

    public static Map<String, FeatureConfig> build(List<String> featureNames) {
        logger.debug("Building FeatureConfig objects for features " + Utils.string(featureNames));
        Map<String, FeatureConfig> configObjMap = featureNames.stream().collect(Collectors.toMap(Function.identity(), ExtractorBasedFeatureConfig::new));
        logger.debug("Built all FeatureConfig objects");
        return configObjMap;
    }

    private static FeatureConfig build(Config featuresConfig, String featureName) {
        FeatureConfig configObj;
        String quotedFeatureName = Utils.quote(featureName);
        ConfigValue configValue = featuresConfig.getValue(quotedFeatureName);
        ConfigValueType configValueType = configValue.valueType();
        switch (configValueType) {
            case STRING: {
                String featureExpr = featuresConfig.getString(quotedFeatureName);
                configObj = new ExtractorBasedFeatureConfig(featureExpr);
                logger.trace("Built ExtractorBasedFeatureConfig object for feature " + featureName);
                break;
            }
            case OBJECT: {
                Config featureCfg = featuresConfig.getConfig(quotedFeatureName);
                if (featuresConfig.hasPath(quotedFeatureName + "." + "window") || featuresConfig.hasPath(quotedFeatureName + "." + "windowParameters")) {
                    configObj = TimeWindowFeatureConfigBuilder.build(featureName, featureCfg);
                    break;
                }
                if (featureCfg.hasPath("def.sqlExpr") || featureCfg.hasPath("def")) {
                    configObj = ExpressionBasedFeatureConfigBuilder.build(featureName, featureCfg);
                    break;
                }
                configObj = ExtractorBasedFeatureConfigBuilder.build(featureName, featureCfg);
                break;
            }
            default: {
                throw new ConfigBuilderException("Expected " + featureName + " value type String or Object, got " + configValueType);
            }
        }
        logger.debug("Built FeatureConfig object for feature " + featureName);
        return configObj;
    }
}

