/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors;

import com.linkedin.feathr.core.config.WindowType;
import com.linkedin.feathr.core.config.producer.anchors.WindowParametersConfig;
import com.linkedin.feathr.core.configbuilder.ConfigBuilderException;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors.FeatureConfigBuilder;
import com.typesafe.config.Config;
import java.time.Duration;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class WindowParametersConfigBuilder {
    private static final Logger logger = Logger.getLogger(FeatureConfigBuilder.class);

    private WindowParametersConfigBuilder() {
    }

    public static WindowParametersConfig build(Config windowParametersConfig) {
        WindowType windowType;
        String type = windowParametersConfig.getString("type");
        try {
            windowType = WindowType.valueOf(type);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigBuilderException("Unsupported window type " + type + "; expected one of " + Arrays.toString((Object[])WindowType.values()));
        }
        Duration size = windowParametersConfig.getDuration("size");
        Duration slidingInterval = null;
        if (windowParametersConfig.hasPath("slidingInterval")) {
            slidingInterval = windowParametersConfig.getDuration("slidingInterval");
        }
        WindowParametersConfig configObj = new WindowParametersConfig(windowType, size, slidingInterval);
        return configObj;
    }
}

