/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.common;

import com.google.common.base.Preconditions;
import com.linkedin.feathr.core.config.producer.common.FeatureTypeConfig;
import com.linkedin.feathr.core.config.producer.definitions.FeatureType;
import com.linkedin.feathr.core.config.producer.definitions.TensorCategory;
import com.linkedin.feathr.core.configbuilder.ConfigBuilderException;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FeatureTypeConfigBuilder {
    private static final Set<FeatureType> SUPPORTED_TENSOR_TYPES = new HashSet<FeatureType>(Arrays.asList(FeatureType.DENSE_TENSOR, FeatureType.SPARSE_TENSOR, FeatureType.RAGGED_TENSOR));

    private FeatureTypeConfigBuilder() {
    }

    public static FeatureTypeConfig build(Config config) {
        FeatureTypeConfig featureTypeConfig = null;
        if (config.hasPath("type")) {
            ConfigValue configValue = config.getValue("type");
            ConfigValueType configValueType = configValue.valueType();
            switch (configValueType) {
                case STRING: {
                    featureTypeConfig = new FeatureTypeConfig(FeatureType.valueOf(config.getString("type")));
                    break;
                }
                case OBJECT: {
                    featureTypeConfig = FeatureTypeConfigBuilder.buildComplexTypeConfig(config.getConfig("type"));
                    break;
                }
                default: {
                    throw new ConfigBuilderException("Expected type  config value type should be String or Object, got " + configValueType);
                }
            }
        }
        return featureTypeConfig;
    }

    private static FeatureTypeConfig buildComplexTypeConfig(Config config) {
        Preconditions.checkArgument((boolean)config.hasPath("type"), (Object)"The config should contain \"type\" child node.");
        FeatureType featureType = FeatureType.valueOf(config.getString("type"));
        if (config.hasPath("tensorCategory")) {
            if (featureType != FeatureType.TENSOR) {
                throw new ConfigBuilderException("tensorCategory field is specified but the feature type is not TENSOR: \n" + config.root().render());
            }
            TensorCategory tensorCategory = TensorCategory.valueOf(config.getString("tensorCategory"));
            switch (tensorCategory) {
                case DENSE: {
                    featureType = FeatureType.DENSE_TENSOR;
                    break;
                }
                case SPARSE: {
                    featureType = FeatureType.SPARSE_TENSOR;
                    break;
                }
                case RAGGED: {
                    featureType = FeatureType.RAGGED_TENSOR;
                    break;
                }
                default: {
                    throw new ConfigBuilderException("The feature type tensorCategory is not supported: " + (Object)((Object)tensorCategory));
                }
            }
        }
        List shapes = null;
        if (config.hasPath("shape")) {
            shapes = config.getIntList("shape");
        }
        List dimensionTypes = null;
        if (config.hasPath("dimensionType")) {
            dimensionTypes = config.getStringList("dimensionType");
        }
        if (shapes != null && dimensionTypes != null && shapes.size() != dimensionTypes.size()) {
            throw new RuntimeException("Sizes of dimensionType and shape should match but got: " + dimensionTypes + " and " + shapes);
        }
        String valType = null;
        if (config.hasPath("valType")) {
            valType = config.getString("valType");
        } else if (SUPPORTED_TENSOR_TYPES.contains((Object)featureType)) {
            throw new RuntimeException("valType field is required for tensor types but is missing in the config: " + config);
        }
        return new FeatureTypeConfig.Builder().setFeatureType(featureType).setShapes(shapes).setDimensionTypes(dimensionTypes).setValType(valType).build();
    }
}

