/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.derivations;

import com.linkedin.feathr.core.config.producer.ExprType;
import com.linkedin.feathr.core.config.producer.TypedExpr;
import com.linkedin.feathr.core.config.producer.common.FeatureTypeConfig;
import com.linkedin.feathr.core.config.producer.derivations.BaseFeatureConfig;
import com.linkedin.feathr.core.config.producer.derivations.DerivationConfig;
import com.linkedin.feathr.core.config.producer.derivations.DerivationConfigWithExpr;
import com.linkedin.feathr.core.config.producer.derivations.DerivationConfigWithExtractor;
import com.linkedin.feathr.core.config.producer.derivations.KeyedFeature;
import com.linkedin.feathr.core.config.producer.derivations.SequentialJoinConfig;
import com.linkedin.feathr.core.config.producer.derivations.SimpleDerivationConfig;
import com.linkedin.feathr.core.configbuilder.ConfigBuilderException;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.common.FeatureTypeConfigBuilder;
import com.linkedin.feathr.core.utils.ConfigUtils;
import com.linkedin.feathr.core.utils.Utils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import org.apache.log4j.Logger;

class DerivationConfigBuilder {
    private static final Logger logger = Logger.getLogger(DerivationConfigBuilder.class);

    private DerivationConfigBuilder() {
    }

    public static DerivationConfig build(String derivedFeatureName, Config derivationsConfig) {
        DerivationConfig configObj;
        String quotedDerivedFeatureName = Utils.quote(derivedFeatureName);
        ConfigValue value = derivationsConfig.getValue(quotedDerivedFeatureName);
        switch (value.valueType()) {
            case STRING: {
                String expr = derivationsConfig.getString(quotedDerivedFeatureName);
                configObj = new SimpleDerivationConfig(new TypedExpr(expr, ExprType.MVEL));
                break;
            }
            case OBJECT: {
                Config derivCfg = derivationsConfig.getConfig(quotedDerivedFeatureName);
                if (derivCfg.hasPath("join")) {
                    configObj = DerivationConfigBuilder.buildWithJoin(derivedFeatureName, derivCfg);
                    break;
                }
                if (derivCfg.hasPath("class")) {
                    configObj = DerivationConfigBuilder.buildWithExtractor(derivedFeatureName, derivCfg);
                    break;
                }
                if (derivCfg.hasPath("inputs")) {
                    configObj = DerivationConfigBuilder.buildWithExpr(derivedFeatureName, derivCfg);
                    break;
                }
                if (derivCfg.hasPath("sqlExpr")) {
                    String sqlExpr = derivCfg.getString("sqlExpr");
                    FeatureTypeConfig featureTypeConfig = FeatureTypeConfigBuilder.build(derivCfg);
                    return new SimpleDerivationConfig(new TypedExpr(sqlExpr, ExprType.SQL), featureTypeConfig);
                }
                if (derivCfg.hasPath("definition")) {
                    String mvelExpr = derivCfg.getString("definition");
                    FeatureTypeConfig featureTypeConfig = FeatureTypeConfigBuilder.build(derivCfg);
                    return new SimpleDerivationConfig(new TypedExpr(mvelExpr, ExprType.MVEL), featureTypeConfig);
                }
                throw new ConfigBuilderException("Expected one of 'definition' or 'class' field in: " + value.render());
            }
            default: {
                throw new ConfigBuilderException("Expected " + derivedFeatureName + " value type String or Object, got " + value.valueType());
            }
        }
        logger.debug((Object)("Built DerivationConfig object for derived feature " + derivedFeatureName));
        return configObj;
    }

    private static DerivationConfigWithExpr buildWithExpr(String derivedFeatureName, Config derivationConfig) {
        List<String> key = DerivationConfigBuilder.getKey(derivationConfig);
        Config inputsConfig = derivationConfig.getConfig("inputs");
        ConfigObject inputsConfigObj = inputsConfig.root();
        Set inputArgs = inputsConfigObj.keySet();
        Map inputs = inputArgs.stream().collect(HashMap::new, (map, arg) -> {
            Config cfg = inputsConfig.getConfig(arg);
            String keyExprOfCfg = DerivationConfigBuilder.getKeyExpr(cfg);
            String inputFeature = cfg.getString("feature");
            KeyedFeature keyedFeature = new KeyedFeature(keyExprOfCfg, inputFeature);
            map.put(arg, keyedFeature);
        }, HashMap::putAll);
        String defType = derivationConfig.hasPath("definition.sqlExpr") ? "definition.sqlExpr" : "definition";
        ExprType defExprType = derivationConfig.hasPath("definition.sqlExpr") ? ExprType.SQL : ExprType.MVEL;
        String definition = derivationConfig.getString(defType);
        FeatureTypeConfig featureTypeConfig = FeatureTypeConfigBuilder.build(derivationConfig);
        DerivationConfigWithExpr configObj = new DerivationConfigWithExpr(key, inputs, new TypedExpr(definition, defExprType), featureTypeConfig);
        logger.trace((Object)("Built DerivationConfigWithExpr object for derived feature " + derivedFeatureName));
        return configObj;
    }

    private static DerivationConfigWithExtractor buildWithExtractor(String derivedFeatureName, Config derivationConfig) {
        List<String> key = DerivationConfigBuilder.getKey(derivationConfig);
        List inputsConfigList = derivationConfig.getConfigList("inputs");
        List<KeyedFeature> inputs = inputsConfigList.stream().map(c -> new KeyedFeature(DerivationConfigBuilder.getKeyExpr(c), c.getString("feature"))).collect(Collectors.toList());
        String name = derivationConfig.getString("class");
        if (!SourceVersion.isName(name)) {
            throw new ConfigBuilderException("Invalid name for extractor class: " + name);
        }
        String className = name;
        FeatureTypeConfig featureTypeConfig = FeatureTypeConfigBuilder.build(derivationConfig);
        DerivationConfigWithExtractor configObj = new DerivationConfigWithExtractor(key, inputs, className, featureTypeConfig);
        logger.trace((Object)("Built DerivationConfigWithExtractor object for derived feature" + derivedFeatureName));
        return configObj;
    }

    private static SequentialJoinConfig buildWithJoin(String sequentialJoinFeatureName, Config derivationConfig) {
        List<String> key = DerivationConfigBuilder.getKey(derivationConfig);
        Config joinConfig = derivationConfig.getConfig("join");
        ConfigObject joinConfigObj = joinConfig.root();
        Set joinArgs = joinConfigObj.keySet();
        if (!joinArgs.contains("base") || !joinArgs.contains("expansion") || joinArgs.size() != 2) {
            throw new ConfigBuilderException("Sequential join config should contains both base and expansion feature config, got" + Utils.string(joinArgs));
        }
        BaseFeatureConfig base = DerivationConfigBuilder.buildBaseFeatureConfig(joinConfig.getConfig("base"));
        Config expansionCfg = joinConfig.getConfig("expansion");
        String keyExprOfCfg = DerivationConfigBuilder.getKeyExpr(expansionCfg);
        String inputFeature = expansionCfg.getString("feature");
        KeyedFeature expansion = new KeyedFeature(keyExprOfCfg, inputFeature);
        String aggregation = derivationConfig.getString("aggregation");
        FeatureTypeConfig featureTypeConfig = FeatureTypeConfigBuilder.build(derivationConfig);
        SequentialJoinConfig configObj = new SequentialJoinConfig(key, base, expansion, aggregation, featureTypeConfig);
        logger.trace((Object)("Built SequentialJoinConfig object for sequential join feature" + sequentialJoinFeatureName));
        return configObj;
    }

    private static BaseFeatureConfig buildBaseFeatureConfig(Config baseConfig) {
        String transformationClass;
        String keyExpr = DerivationConfigBuilder.getKeyExpr(baseConfig);
        String feature = baseConfig.getString("feature");
        List<String> outputKey = baseConfig.hasPath("outputKey") ? DerivationConfigBuilder.getKey(baseConfig, "outputKey") : null;
        String transformation = baseConfig.hasPath("transformation") ? baseConfig.getString("transformation") : null;
        String string = transformationClass = baseConfig.hasPath("transformationClass") ? baseConfig.getString("transformationClass") : null;
        if (transformation != null && transformationClass != null) {
            throw new ConfigBuilderException("Sequential join base feature config cannot have both transformation \"" + transformation + "\" and transformationClass \"" + transformationClass + "\".");
        }
        return new BaseFeatureConfig(keyExpr, feature, outputKey, transformation, transformationClass);
    }

    private static List<String> getKey(Config config, String keyField) {
        List<String> key;
        ConfigValueType keyValueType = config.getValue(keyField).valueType();
        switch (keyValueType) {
            case STRING: {
                key = Collections.singletonList(config.getString(keyField));
                break;
            }
            case LIST: {
                key = config.getStringList(keyField);
                break;
            }
            default: {
                throw new ConfigBuilderException("Expected key type String or List[String], got " + keyValueType);
            }
        }
        return key;
    }

    private static List<String> getKey(Config config) {
        return DerivationConfigBuilder.getKey(config, "key");
    }

    private static String getKeyExpr(Config config) {
        return ConfigUtils.getHoconString(config, "key");
    }
}

