/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.derivations;

import com.linkedin.feathr.core.config.producer.derivations.DerivationConfig;
import com.linkedin.feathr.core.config.producer.derivations.DerivationsConfig;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.derivations.DerivationConfigBuilder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;

public class DerivationsConfigBuilder {
    private static final Logger logger = Logger.getLogger(DerivationsConfigBuilder.class);

    private DerivationsConfigBuilder() {
    }

    public static DerivationsConfig build(Config config) {
        logger.debug((Object)"Building DerivationConfig objects");
        ConfigObject configObj = config.root();
        Stream derivedFeatureNames = configObj.keySet().stream();
        Map<String, DerivationConfig> nameConfigMap = derivedFeatureNames.collect(Collectors.toMap(Function.identity(), derivedFeatureName -> DerivationConfigBuilder.build(derivedFeatureName, config)));
        DerivationsConfig derivationsConfig = new DerivationsConfig(nameConfigMap);
        logger.debug((Object)"Built all DerivationConfig objects");
        return derivationsConfig;
    }
}

