/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.sources;

import com.linkedin.feathr.core.config.producer.sources.HdfsConfig;
import com.linkedin.feathr.core.configbuilder.ConfigBuilderException;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.sources.HdfsConfigWithRegularDataBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.sources.HdfsConfigWithSlidingWindowBuilder;
import com.typesafe.config.Config;
import org.apache.log4j.Logger;

class HdfsConfigBuilder {
    private static final Logger logger = Logger.getLogger(HdfsConfigBuilder.class);

    private HdfsConfigBuilder() {
    }

    public static HdfsConfig build(String sourceName, Config sourceConfig) {
        boolean hasTimePartitionPattern = sourceConfig.hasPath("timePartitionPattern");
        boolean hasTimeSnapshot = sourceConfig.hasPath("hasTimeSnapshot");
        boolean hasIsTimeSeries = sourceConfig.hasPath("isTimeSeries");
        if (hasTimePartitionPattern && (hasTimeSnapshot || hasIsTimeSeries)) {
            throw new ConfigBuilderException("hasTimeSnapshot and isTimeSeries are legacy fields. They cannot coexist with timePartitionPattern. Please remove them from the source " + sourceName);
        }
        if (hasTimeSnapshot && hasIsTimeSeries) {
            throw new ConfigBuilderException("hasTimeSnapshot and isTimeSeries cannot coexist in source " + sourceName);
        }
        boolean hasSlidingWindowConfig = sourceConfig.hasPath("timeWindowParameters");
        HdfsConfig configObj = hasSlidingWindowConfig ? HdfsConfigWithSlidingWindowBuilder.build(sourceName, sourceConfig) : HdfsConfigWithRegularDataBuilder.build(sourceName, sourceConfig);
        logger.debug((Object)("Built HdfsConfig object for source " + sourceName));
        return configObj;
    }
}

