/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.sources;

import com.linkedin.feathr.core.config.producer.sources.HdfsConfigWithRegularData;
import com.linkedin.feathr.core.configbuilder.ConfigBuilderException;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueType;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

class HdfsConfigWithRegularDataBuilder {
    private static final Logger logger = Logger.getLogger(HdfsConfigWithRegularDataBuilder.class);

    private HdfsConfigWithRegularDataBuilder() {
    }

    public static HdfsConfigWithRegularData build(String sourceName, Config sourceConfig) {
        String path = sourceConfig.getString("location.path");
        String timePartitionPattern = sourceConfig.hasPath("timePartitionPattern") ? sourceConfig.getString("timePartitionPattern") : null;
        boolean hasTimeSnapshot = sourceConfig.hasPath("hasTimeSnapshot") && sourceConfig.getBoolean("hasTimeSnapshot");
        HdfsConfigWithRegularData configObj = new HdfsConfigWithRegularData(sourceName, path, timePartitionPattern, hasTimeSnapshot);
        logger.trace((Object)("Built HdfsConfigWithRegularData object for source" + sourceName));
        return configObj;
    }

    private static List<String> getStringList(Config sourceConfig, String field) {
        List<String> stringList;
        ConfigValueType valueType = sourceConfig.getValue(field).valueType();
        switch (valueType) {
            case STRING: {
                stringList = Collections.singletonList(sourceConfig.getString(field));
                break;
            }
            case LIST: {
                stringList = sourceConfig.getStringList(field);
                break;
            }
            default: {
                throw new ConfigBuilderException("Expected " + field + " value type String or List, got " + valueType);
            }
        }
        return stringList;
    }
}

