/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.sources;

import com.linkedin.feathr.core.config.producer.sources.KafkaConfig;
import com.linkedin.feathr.core.config.producer.sources.SlidingWindowAggrConfig;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.sources.SlidingWindowAggrConfigBuilder;
import com.typesafe.config.Config;
import org.apache.log4j.Logger;

class KafkaConfigBuilder {
    private static final Logger logger = Logger.getLogger(KafkaConfigBuilder.class);

    private KafkaConfigBuilder() {
    }

    public static KafkaConfig build(String sourceName, Config sourceConfig) {
        String stream = sourceConfig.getString("stream");
        boolean isTimeSeries = sourceConfig.hasPath("isTimeSeries") && sourceConfig.getBoolean("isTimeSeries");
        SlidingWindowAggrConfig swaConfig = isTimeSeries ? SlidingWindowAggrConfigBuilder.build(sourceConfig) : null;
        KafkaConfig configObj = new KafkaConfig(sourceName, stream, swaConfig);
        logger.debug((Object)("Built KafkaConfig object for source " + sourceName));
        return configObj;
    }
}

