/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.sources;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.feathr.core.config.producer.sources.RestliConfig;
import com.linkedin.feathr.core.configbuilder.ConfigBuilderException;
import com.linkedin.feathr.core.utils.Utils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValueType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

class RestliConfigBuilder {
    private static final Logger logger = Logger.getLogger(RestliConfigBuilder.class);

    private RestliConfigBuilder() {
    }

    public static RestliConfig build(String sourceName, Config sourceConfig) {
        String resourceName = sourceConfig.hasPath("restResourceName") ? sourceConfig.getString("restResourceName") : sourceConfig.getString("restResouceName");
        Map<String, Object> reqParams = sourceConfig.hasPath("restReqParams") ? RestliConfigBuilder.buildReqParams(sourceConfig) : null;
        PathSpec pathSpec = sourceConfig.hasPath("pathSpec") ? RestliConfigBuilder.buildPathSpec(sourceConfig) : null;
        String keyExpr = null;
        String finder = null;
        if (sourceConfig.hasPath("keyExpr")) {
            keyExpr = sourceConfig.getString("keyExpr");
        } else if (sourceConfig.hasPath("restEntityType")) {
            String entityType = sourceConfig.getString("restEntityType");
            keyExpr = String.format("toUrn(\"%s\", key[0])", entityType);
        }
        if (sourceConfig.hasPath("finder")) {
            finder = sourceConfig.getString("finder");
        }
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{finder, keyExpr})) {
            throw new ConfigBuilderException("Rest.li config cannot have both blank \"keyExpr\" and \"finder\" fields");
        }
        RestliConfig configObj = new RestliConfig(sourceName, resourceName, keyExpr, reqParams, pathSpec, finder);
        logger.debug((Object)("Built RestliConfig object for source " + sourceName));
        return configObj;
    }

    private static Map<String, Object> buildReqParams(Config sourceConfig) {
        Config reqParamsConfig = sourceConfig.getConfig("restReqParams");
        ConfigObject reqParamsConfigObj = reqParamsConfig.root();
        Set reqParamsKeys = reqParamsConfigObj.keySet();
        logger.debug((Object)("reqParamsKeys: " + Utils.string(reqParamsKeys)));
        BiConsumer<Map, String> accumulator = (acc, key) -> {
            ConfigValueType configValueType = reqParamsConfig.getValue(key).valueType();
            block0 : switch (configValueType) {
                case STRING: {
                    acc.put(key, reqParamsConfig.getString(key));
                    break;
                }
                case OBJECT: {
                    String keyWord;
                    Config paramConfig = reqParamsConfig.getConfig(key);
                    switch (keyWord = (String)paramConfig.root().keySet().iterator().next()) {
                        case "json": {
                            ConfigValueType valueType = paramConfig.getValue("json").valueType();
                            Config config = valueType == ConfigValueType.OBJECT ? paramConfig.getConfig("json") : ConfigFactory.parseString((String)paramConfig.getString("json"));
                            DataMap dataMap = RestliConfigBuilder.buildDataMap(config);
                            acc.put(key, dataMap);
                            break block0;
                        }
                        case "jsonArray": {
                            ConfigValueType jsonArrayValueType = paramConfig.getValue("jsonArray").valueType();
                            Config jsonArrayConfig = jsonArrayValueType == ConfigValueType.OBJECT ? paramConfig.getConfig("jsonArray") : ConfigFactory.parseString((String)paramConfig.getString("jsonArray"));
                            DataList dataList = RestliConfigBuilder.buildDataList(jsonArrayConfig);
                            acc.put(key, dataList);
                            break block0;
                        }
                        case "mvel": {
                            String mvelExpr = paramConfig.getString("mvel");
                            DataMap mvelDataMap = new DataMap();
                            mvelDataMap.put((Object)"mvel", (Object)mvelExpr);
                            acc.put(key, mvelDataMap);
                            break block0;
                        }
                        case "file": {
                            StringBuilder warnSb = new StringBuilder();
                            warnSb.append("Handling of keyword ").append("file").append(" in ").append("restReqParams").append(" is not yet implemented");
                            logger.warn((Object)warnSb.toString());
                            break block0;
                        }
                    }
                    StringBuilder errSb = new StringBuilder();
                    errSb.append("Unsupported key ").append(keyWord).append(". Keys in ").append("restReqParams").append(" object must be one of ").append("json").append(", ").append("jsonArray").append(", ").append("mvel").append(", or ").append("file");
                    throw new ConfigBuilderException(errSb.toString());
                }
                default: {
                    throw new ConfigBuilderException("Expected value type 'String' or 'Object'; found " + configValueType);
                }
            }
        };
        return reqParamsKeys.stream().collect(HashMap::new, accumulator, Map::putAll);
    }

    private static DataMap buildDataMap(Config jsonConfig) {
        Set keys = jsonConfig.root().keySet();
        Map map = keys.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((Config)jsonConfig).getString(arg_0)));
        return new DataMap(map);
    }

    private static DataList buildDataList(Config jsonArrayConfig) {
        List listOfConfigs = jsonArrayConfig.getConfigList("array");
        List listOfDataMaps = listOfConfigs.stream().map(config -> {
            Set keys = config.root().keySet();
            Map dm = keys.stream().collect(Collectors.toMap(Function.identity(), k -> config.getString(k)));
            return new DataMap(dm);
        }).collect(Collectors.toList());
        return new DataList(listOfDataMaps);
    }

    private static PathSpec buildPathSpec(Config sourceConfig) {
        PathSpec pathSpec;
        ConfigValueType configValueType = sourceConfig.getValue("pathSpec").valueType();
        switch (configValueType) {
            case STRING: {
                String pathSpecStr = sourceConfig.getString("pathSpec");
                pathSpec = new PathSpec(pathSpecStr);
                break;
            }
            case LIST: {
                List pathSpecList = sourceConfig.getStringList("pathSpec");
                String[] pathSpecArray = new String[pathSpecList.size()];
                pathSpecArray = pathSpecList.toArray(pathSpecArray);
                pathSpec = new PathSpec(pathSpecArray);
                break;
            }
            default: {
                throw new ConfigBuilderException("pathSpec must be of 'String' or 'List', got " + configValueType);
            }
        }
        return pathSpec;
    }
}

