/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.sources;

import com.linkedin.feathr.core.config.producer.sources.SourceConfig;
import com.linkedin.feathr.core.config.producer.sources.SourceType;
import com.linkedin.feathr.core.configbuilder.ConfigBuilderException;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.sources.CouchbaseConfigBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.sources.CustomSourceConfigBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.sources.EspressoConfigBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.sources.HdfsConfigBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.sources.KafkaConfigBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.sources.PassThroughConfigBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.sources.PinotConfigBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.sources.RestliConfigBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.sources.RocksDbConfigBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.sources.VeniceConfigBuilder;
import com.typesafe.config.Config;
import org.apache.log4j.Logger;

class SourceConfigBuilder {
    private static final Logger logger = Logger.getLogger(SourceConfigBuilder.class);

    private SourceConfigBuilder() {
    }

    public static SourceConfig build(String sourceName, Config sourceConfig) {
        SourceConfig configObj;
        if (sourceConfig.hasPath("type")) {
            String sourceTypeStr = sourceConfig.getString("type");
            SourceType sourceType = SourceType.valueOf(sourceTypeStr);
            switch (sourceType) {
                case HDFS: {
                    configObj = HdfsConfigBuilder.build(sourceName, sourceConfig);
                    break;
                }
                case ESPRESSO: {
                    configObj = EspressoConfigBuilder.build(sourceName, sourceConfig);
                    break;
                }
                case RESTLI: {
                    configObj = RestliConfigBuilder.build(sourceName, sourceConfig);
                    break;
                }
                case VENICE: {
                    configObj = VeniceConfigBuilder.build(sourceName, sourceConfig);
                    break;
                }
                case KAFKA: {
                    configObj = KafkaConfigBuilder.build(sourceName, sourceConfig);
                    break;
                }
                case ROCKSDB: {
                    configObj = RocksDbConfigBuilder.build(sourceName, sourceConfig);
                    break;
                }
                case PASSTHROUGH: {
                    configObj = PassThroughConfigBuilder.build(sourceName, sourceConfig);
                    break;
                }
                case COUCHBASE: {
                    configObj = CouchbaseConfigBuilder.build(sourceName, sourceConfig);
                    break;
                }
                case CUSTOM: {
                    configObj = CustomSourceConfigBuilder.build(sourceName, sourceConfig);
                    break;
                }
                case PINOT: {
                    configObj = PinotConfigBuilder.build(sourceName, sourceConfig);
                    break;
                }
                default: {
                    throw new ConfigBuilderException("Unknown source type " + sourceTypeStr);
                }
            }
        } else if (sourceConfig.hasPath("location.path")) {
            configObj = HdfsConfigBuilder.build(sourceName, sourceConfig);
        } else {
            throw new ConfigBuilderException("Unsupported source type for source " + sourceName);
        }
        return configObj;
    }
}

