/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.sources;

import com.linkedin.feathr.core.config.producer.sources.SourceConfig;
import com.linkedin.feathr.core.config.producer.sources.SourcesConfig;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.sources.SourceConfigBuilder;
import com.linkedin.feathr.core.utils.Utils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;

public class SourcesConfigBuilder {
    private static final Logger logger = Logger.getLogger(SourcesConfigBuilder.class);

    private SourcesConfigBuilder() {
    }

    public static SourcesConfig build(Config config) {
        ConfigObject configObj = config.root();
        Stream sourceNames = configObj.keySet().stream();
        Map<String, SourceConfig> nameConfigMap = sourceNames.collect(Collectors.toMap(Function.identity(), sourceName -> SourceConfigBuilder.build(sourceName, config.getConfig(Utils.quote(sourceName)))));
        SourcesConfig sourcesConfig = new SourcesConfig(nameConfigMap);
        logger.debug((Object)"Built all SourceConfig objects");
        return sourcesConfig;
    }
}

