/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configdataprovider;

import com.linkedin.feathr.core.configdataprovider.BaseConfigDataProvider;
import com.linkedin.feathr.core.configdataprovider.ConfigDataProviderException;
import com.linkedin.feathr.core.utils.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.log4j.Logger;

public class UrlConfigDataProvider
extends BaseConfigDataProvider {
    private static final Logger logger = Logger.getLogger(UrlConfigDataProvider.class);
    private final List<URL> _urls;

    public UrlConfigDataProvider(URL url) {
        this(Collections.singletonList(url));
    }

    public UrlConfigDataProvider(List<URL> urls) {
        Objects.requireNonNull(urls, "url list can't be null");
        for (URL url : urls) {
            Objects.requireNonNull(url, "url can't be null");
        }
        this._urls = urls;
    }

    @Override
    public List<Reader> getConfigDataReaders() {
        for (URL url : this._urls) {
            try {
                InputStream in = url.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                logger.debug((Object)("Created Reader object for URL " + url));
                this._readers.add(reader);
            }
            catch (IOException e) {
                throw new ConfigDataProviderException("Error creating a Reader from URL " + url, e);
            }
        }
        return this._readers;
    }

    @Override
    public String getConfigDataInfo() {
        return "URLs: " + Utils.string(this._urls);
    }

    public List<URL> getUrls() {
        return Collections.unmodifiableList(this._urls);
    }
}

