/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configvalidator;

import com.linkedin.feathr.core.configvalidator.ValidationStatus;
import com.linkedin.feathr.core.configvalidator.ValidationType;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public class ValidationResult {
    private ValidationType _type;
    private ValidationStatus _status;
    private String _details;
    private final Throwable _cause;
    public static final ValidationResult VALID_SYNTAX = new ValidationResult(ValidationType.SYNTACTIC, ValidationStatus.VALID);
    public static final ValidationResult VALID_SEMANTICS = new ValidationResult(ValidationType.SEMANTIC, ValidationStatus.VALID);

    public ValidationResult(ValidationType type, ValidationStatus status) {
        this(type, status, null, null);
    }

    public ValidationResult(ValidationType type, ValidationStatus status, String details) {
        this(type, status, details, null);
    }

    public ValidationResult(ValidationType type, ValidationStatus status, String details, Throwable cause) {
        Objects.requireNonNull(type, "ValidationType can't be null");
        Objects.requireNonNull(status, "ValidationStatus can't be null");
        this._type = type;
        this._status = status;
        this._details = details;
        this._cause = cause;
    }

    public ValidationType getValidationType() {
        return this._type;
    }

    public ValidationStatus getValidationStatus() {
        return this._status;
    }

    public Optional<String> getDetails() {
        return Optional.ofNullable(this._details);
    }

    public Optional<Throwable> getCause() {
        return Optional.ofNullable(this._cause);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationResult result = (ValidationResult)o;
        return this._type == result._type && this._status == result._status && Objects.equals(this._details, result._details) && Objects.equals(this._cause, result._cause);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._type, this._status, this._details, this._cause});
    }

    public String toString() {
        return new StringJoiner(", ", ValidationResult.class.getSimpleName() + "[", "]").add("type = " + (Object)((Object)this._type)).add("status = " + (Object)((Object)this._status)).add("details = '" + this._details + "'").add("cause = " + this._cause).toString();
    }
}

