/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configvalidator.typesafe;

import com.linkedin.feathr.core.config.ConfigType;
import com.linkedin.feathr.core.config.consumer.JoinConfig;
import com.linkedin.feathr.core.config.producer.FeatureDefConfig;
import com.linkedin.feathr.core.config.producer.anchors.AnchorConfig;
import com.linkedin.feathr.core.config.producer.anchors.AnchorConfigWithExtractor;
import com.linkedin.feathr.core.config.producer.anchors.AnchorConfigWithKeyExtractor;
import com.linkedin.feathr.core.config.producer.anchors.AnchorsConfig;
import com.linkedin.feathr.core.config.producer.derivations.DerivationConfig;
import com.linkedin.feathr.core.config.producer.derivations.DerivationConfigWithExtractor;
import com.linkedin.feathr.core.config.producer.derivations.DerivationsConfig;
import com.linkedin.feathr.core.configbuilder.ConfigBuilder;
import com.linkedin.feathr.core.configdataprovider.ConfigDataProvider;
import com.linkedin.feathr.core.configvalidator.typesafe.FeatureDefConfigSemanticValidator;
import com.linkedin.feathr.core.configvalidator.typesafe.JoinConfSemanticValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ExtractorClassValidationUtils {
    private ExtractorClassValidationUtils() {
    }

    public static Set<String> getExtractorClasses(Map<ConfigType, ConfigDataProvider> configDataProviderMap) {
        HashSet<String> allClasses = new HashSet<String>();
        ConfigBuilder configBuilder = ConfigBuilder.get();
        if (configDataProviderMap.containsKey((Object)ConfigType.FeatureDef)) {
            FeatureDefConfig featureDefConfig = configBuilder.buildFeatureDefConfig(configDataProviderMap.get((Object)ConfigType.FeatureDef));
            HashMap<String, Set<String>> anchorFeaturesMap = new HashMap<String, Set<String>>();
            Map<String, List<String>> anchorExtractorsMap = ExtractorClassValidationUtils.getExtractorClassesInAnchors(featureDefConfig, anchorFeaturesMap);
            Map<String, String> derivedExtractorMap = ExtractorClassValidationUtils.getExtractorClassesInDerivations(featureDefConfig);
            if (configDataProviderMap.containsKey((Object)ConfigType.Join)) {
                JoinConfig joinConfig = configBuilder.buildJoinConfig(configDataProviderMap.get((Object)ConfigType.Join));
                Set<String> requiredFeatureNames = FeatureDefConfigSemanticValidator.getRequiredFeatureNames(featureDefConfig, JoinConfSemanticValidator.getRequestedFeatureNames(joinConfig));
                return ExtractorClassValidationUtils.filterClassesWithRequiredFeatures(requiredFeatureNames, anchorExtractorsMap, anchorFeaturesMap, derivedExtractorMap);
            }
            allClasses.addAll(anchorExtractorsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
            allClasses.addAll(derivedExtractorMap.values());
        }
        return allClasses;
    }

    private static Map<String, List<String>> getExtractorClassesInAnchors(FeatureDefConfig featureDefConfig, Map<String, Set<String>> anchorFeaturesMap) {
        HashMap<String, List<String>> anchorExtractorsMap = new HashMap<String, List<String>>();
        Map<String, AnchorConfig> anchors = featureDefConfig.getAnchorsConfig().orElse(new AnchorsConfig(new HashMap<String, AnchorConfig>())).getAnchors();
        for (Map.Entry<String, AnchorConfig> entry : anchors.entrySet()) {
            String anchorName = entry.getKey();
            AnchorConfig anchor = entry.getValue();
            if (anchor instanceof AnchorConfigWithExtractor) {
                AnchorConfigWithExtractor anchorWithExtractor = (AnchorConfigWithExtractor)anchor;
                anchorExtractorsMap.put(anchorName, new ArrayList<String>(Arrays.asList(anchorWithExtractor.getExtractor())));
                anchorWithExtractor.getKeyExtractor().map(e -> ((List)anchorExtractorsMap.get(anchorName)).add(e));
                anchorFeaturesMap.put(anchorName, anchorWithExtractor.getFeatures().keySet());
                continue;
            }
            if (!(anchor instanceof AnchorConfigWithKeyExtractor)) continue;
            AnchorConfigWithKeyExtractor anchorWithKeyExtractor = (AnchorConfigWithKeyExtractor)anchor;
            anchorExtractorsMap.put(anchorName, Collections.singletonList(anchorWithKeyExtractor.getKeyExtractor()));
            anchorFeaturesMap.put(anchorName, anchorWithKeyExtractor.getFeatures().keySet());
        }
        return anchorExtractorsMap;
    }

    private static Map<String, String> getExtractorClassesInDerivations(FeatureDefConfig featureDefConfig) {
        Map<String, DerivationConfig> derivations = featureDefConfig.getDerivationsConfig().orElse(new DerivationsConfig(new HashMap<String, DerivationConfig>())).getDerivations();
        HashMap<String, String> derivedExtractorMap = new HashMap<String, String>();
        for (Map.Entry<String, DerivationConfig> entry : derivations.entrySet()) {
            String derivedFeature = entry.getKey();
            DerivationConfig derivation = entry.getValue();
            if (!(derivation instanceof DerivationConfigWithExtractor)) continue;
            DerivationConfigWithExtractor derivationWithExtractor = (DerivationConfigWithExtractor)derivation;
            derivedExtractorMap.put(derivedFeature, derivationWithExtractor.getClassName());
        }
        return derivedExtractorMap;
    }

    private static Set<String> filterClassesWithRequiredFeatures(Set<String> requiredFeatureNames, Map<String, List<String>> anchorExtractorsMap, Map<String, Set<String>> anchorFeaturesMap, Map<String, String> derivedExtractorMap) {
        HashSet<String> allClasses = new HashSet<String>();
        Set requiredAnchors = anchorFeaturesMap.entrySet().stream().filter(e -> ((Set)e.getValue()).removeAll(requiredFeatureNames)).map(Map.Entry::getKey).collect(Collectors.toSet());
        anchorExtractorsMap.entrySet().stream().filter(e -> requiredAnchors.contains(e.getKey())).map(Map.Entry::getValue).forEach(allClasses::addAll);
        derivedExtractorMap.entrySet().stream().filter(e -> requiredFeatureNames.contains(e.getKey())).map(Map.Entry::getValue).forEach(allClasses::add);
        return allClasses;
    }
}

