/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configvalidator.typesafe;

import com.linkedin.feathr.core.config.ConfigType;
import com.linkedin.feathr.core.config.consumer.JoinConfig;
import com.linkedin.feathr.core.config.producer.FeatureDefConfig;
import com.linkedin.feathr.core.config.producer.sources.SourceConfig;
import com.linkedin.feathr.core.config.producer.sources.SourcesConfig;
import com.linkedin.feathr.core.configbuilder.ConfigBuilder;
import com.linkedin.feathr.core.configdataprovider.ConfigDataProvider;
import com.linkedin.feathr.core.configvalidator.ConfigValidationException;
import com.linkedin.feathr.core.configvalidator.ValidationResult;
import com.linkedin.feathr.core.configvalidator.ValidationStatus;
import com.linkedin.feathr.core.configvalidator.ValidationType;
import com.linkedin.feathr.core.configvalidator.typesafe.FeatureDefConfigSemanticValidator;
import com.linkedin.feathr.core.configvalidator.typesafe.JoinConfSemanticValidator;
import com.linkedin.feathr.core.configvalidator.typesafe.TypesafeConfigValidator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;

public class FeatureConsumerConfValidator
extends TypesafeConfigValidator {
    @Override
    public Map<ConfigType, ValidationResult> validate(Map<ConfigType, ConfigDataProvider> configTypeWithDataProvider, ValidationType validationType) {
        switch (validationType) {
            case SYNTACTIC: {
                return super.validate(configTypeWithDataProvider, ValidationType.SYNTACTIC);
            }
            case SEMANTIC: {
                return this.validateSemantics(configTypeWithDataProvider);
            }
        }
        throw new ConfigValidationException("Unsupported validation type: " + validationType.name());
    }

    private Map<ConfigType, ValidationResult> validateSemantics(Map<ConfigType, ConfigDataProvider> configTypeWithDataProvider) {
        Optional<Object> optionalFeatureDefConfig;
        Optional<Object> sourceNameValidationWarnStr;
        Map<ConfigType, ValidationResult> result = new HashMap<ConfigType, ValidationResult>();
        if (configTypeWithDataProvider == null || configTypeWithDataProvider.isEmpty()) {
            return result;
        }
        ConfigBuilder configBuilder = ConfigBuilder.get();
        if (configTypeWithDataProvider.containsKey((Object)ConfigType.FeatureDef)) {
            sourceNameValidationWarnStr = FeatureConsumerConfValidator.validateFeatureDefConfigSourceNames(configTypeWithDataProvider.get((Object)ConfigType.FeatureDef));
            ConfigDataProvider featureDefConfigDataProvider = configTypeWithDataProvider.get((Object)ConfigType.FeatureDef);
            optionalFeatureDefConfig = Optional.of(configBuilder.buildFeatureDefConfig(featureDefConfigDataProvider));
        } else {
            optionalFeatureDefConfig = Optional.empty();
            sourceNameValidationWarnStr = Optional.empty();
        }
        if (configTypeWithDataProvider.containsKey((Object)ConfigType.Join)) {
            ConfigDataProvider joinConfigDataProvider = configTypeWithDataProvider.get((Object)ConfigType.Join);
            JoinConfig joinConfig = configBuilder.buildJoinConfig(joinConfigDataProvider);
            String errMsg = String.join((CharSequence)"", "Can not perform semantic validation as the Join config is", "provided but the FeatureDef config is missing.");
            FeatureDefConfig featureDefConfig = (FeatureDefConfig)optionalFeatureDefConfig.orElseThrow(() -> new ConfigValidationException(errMsg));
            result = this.validateConsumerConfigSemantics(joinConfig, featureDefConfig);
        } else {
            FeatureDefConfig featureDefConfig = (FeatureDefConfig)optionalFeatureDefConfig.orElseThrow(() -> new ConfigValidationException("Can not perform semantic validation as the FeatureDef config is missing."));
            result.put(ConfigType.FeatureDef, this.validateSemantics(featureDefConfig));
        }
        if (sourceNameValidationWarnStr.isPresent() && result.containsKey((Object)ConfigType.FeatureDef)) {
            result.put(ConfigType.FeatureDef, new ValidationResult(ValidationType.SEMANTIC, ValidationStatus.WARN, (String)sourceNameValidationWarnStr.get()));
        }
        return result;
    }

    private Map<ConfigType, ValidationResult> validateConsumerConfigSemantics(JoinConfig joinConfig, FeatureDefConfig featureDefConfig) {
        HashMap<ConfigType, ValidationResult> validationResultMap = new HashMap<ConfigType, ValidationResult>();
        FeatureDefConfigSemanticValidator featureDefConfSemanticValidator = new FeatureDefConfigSemanticValidator(true, true);
        validationResultMap.put(ConfigType.FeatureDef, featureDefConfSemanticValidator.validate(featureDefConfig));
        JoinConfSemanticValidator joinConfSemanticValidator = new JoinConfSemanticValidator();
        validationResultMap.put(ConfigType.Join, joinConfSemanticValidator.validate(joinConfig, featureDefConfSemanticValidator.getFeatureAccessInfo(featureDefConfig)));
        return validationResultMap;
    }

    private static Optional<String> validateFeatureDefConfigSourceNames(ConfigDataProvider configDataProvider) {
        String warnMsg;
        StringJoiner warnMsgSj = new StringJoiner("\n");
        HashSet<String> sourcesSet = new HashSet<String>();
        HashSet<String> duplicateSourceNames = new HashSet<String>();
        ConfigBuilder configBuilder = ConfigBuilder.get();
        List<FeatureDefConfig> builtFeatureDefConfigList = configBuilder.buildFeatureDefConfigList(configDataProvider);
        for (FeatureDefConfig featureDefConfig : builtFeatureDefConfigList) {
            if (!featureDefConfig.getSourcesConfig().isPresent()) continue;
            SourcesConfig source = featureDefConfig.getSourcesConfig().get();
            Map<String, SourceConfig> sources = source.getSources();
            for (String sourceName : sources.keySet()) {
                if (sourcesSet.contains(sourceName)) {
                    duplicateSourceNames.add(sourceName);
                    continue;
                }
                sourcesSet.add(sourceName);
            }
        }
        if (duplicateSourceNames.size() > 0) {
            warnMsgSj.add("The following source name(s) are duplicates between two or more feature definition configs: ");
            for (String entry : duplicateSourceNames) {
                warnMsgSj.add("source name: " + entry);
            }
            warnMsgSj.add("File paths of two or more files that have duplicate source names: \n" + configDataProvider.getConfigDataInfo());
        }
        Optional<String> returnString = (warnMsg = warnMsgSj.toString()).isEmpty() ? Optional.empty() : Optional.of(warnMsg);
        return returnString;
    }

    @Override
    public ValidationResult validateSemantics(FeatureDefConfig featureDefConfig) {
        return new FeatureDefConfigSemanticValidator(true, true).validate(featureDefConfig);
    }
}

