/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configvalidator.typesafe;

import com.linkedin.feathr.core.config.producer.FeatureDefConfig;
import com.linkedin.feathr.core.config.producer.anchors.AnchorConfig;
import com.linkedin.feathr.core.config.producer.anchors.AnchorsConfig;
import com.linkedin.feathr.core.config.producer.sources.HdfsConfig;
import com.linkedin.feathr.core.config.producer.sources.SourceConfig;
import com.linkedin.feathr.core.config.producer.sources.SourceType;
import com.linkedin.feathr.core.config.producer.sources.SourcesConfig;
import com.linkedin.feathr.core.configvalidator.ValidationResult;
import com.linkedin.feathr.core.configvalidator.ValidationStatus;
import com.linkedin.feathr.core.configvalidator.ValidationType;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class HdfsSourceValidator {
    private static final HdfsSourceValidator HDFS_SOURCE_VALIDATOR = new HdfsSourceValidator();
    static Set<String> gridManagedDataSets = Stream.of("/data/tracking", "/data/tracking_column", "/data/databases", "/data/service", "/data/service_column", "/jobs/metrics/ump_v2/metrics", "/jobs/metrics/ump_v2/metrics_union", "/jobs/metrics/ump_v2/metrics_union_column", "/jobs/metrics/udp/snapshot", "/jobs/metrics/udp/datafiles").collect(Collectors.toSet());

    private HdfsSourceValidator() {
    }

    static HdfsSourceValidator getInstance() {
        return HDFS_SOURCE_VALIDATOR;
    }

    ValidationResult validate(FeatureDefConfig featureDefConfig) {
        Map<String, String> invalidPaths = this.getInvalidManagedDataSets(featureDefConfig);
        if (!invalidPaths.isEmpty()) {
            Set invalidSourceInfoSet = invalidPaths.entrySet().stream().map(e -> String.join((CharSequence)": ", (CharSequence)e.getKey(), (CharSequence)e.getValue())).collect(Collectors.toSet());
            String warnMsg = String.join((CharSequence)"", "Based on go/dalipolicy, the following HDFS sources are invalid. ", "For managed datasets, you need to use DALI path instead of directly using HDFS path: \n", String.join((CharSequence)"\n", invalidSourceInfoSet), "\nFor detailed information, please refer to go/dalipolicy");
            return new ValidationResult(ValidationType.SEMANTIC, ValidationStatus.WARN, warnMsg);
        }
        return new ValidationResult(ValidationType.SEMANTIC, ValidationStatus.VALID);
    }

    Map<String, String> getInvalidManagedDataSets(FeatureDefConfig featureDefConfig) {
        Map<String, String> invalidDataSets = featureDefConfig.getSourcesConfig().orElse(new SourcesConfig(Collections.emptyMap())).getSources().entrySet().stream().filter(e -> ((SourceConfig)e.getValue()).getSourceType().equals((Object)SourceType.HDFS)).map(e -> new AbstractMap.SimpleEntry(e.getKey(), ((HdfsConfig)e.getValue()).getPath())).filter(e -> gridManagedDataSets.stream().anyMatch(prefix -> ((String)e.getValue()).startsWith((String)prefix))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        featureDefConfig.getAnchorsConfig().orElse(new AnchorsConfig(Collections.emptyMap())).getAnchors().entrySet().stream().filter(e -> ((AnchorConfig)e.getValue()).getSource().startsWith("/")).map(e -> new AbstractMap.SimpleEntry(e.getKey(), ((AnchorConfig)e.getValue()).getSource())).filter(e -> gridManagedDataSets.stream().anyMatch(prefix -> ((String)e.getValue()).startsWith((String)prefix))).forEach(e -> {
            String cfr_ignored_0 = (String)invalidDataSets.put((String)e.getKey(), (String)e.getValue());
        });
        return invalidDataSets;
    }
}

