/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configvalidator.typesafe;

import com.linkedin.feathr.core.config.ConfigType;
import com.linkedin.feathr.core.config.consumer.JoinConfig;
import com.linkedin.feathr.core.config.producer.FeatureDefConfig;
import com.linkedin.feathr.core.configbuilder.typesafe.TypesafeConfigBuilder;
import com.linkedin.feathr.core.configdataprovider.ConfigDataProvider;
import com.linkedin.feathr.core.configvalidator.ConfigValidationException;
import com.linkedin.feathr.core.configvalidator.ConfigValidator;
import com.linkedin.feathr.core.configvalidator.ValidationResult;
import com.linkedin.feathr.core.configvalidator.ValidationStatus;
import com.linkedin.feathr.core.configvalidator.ValidationType;
import com.linkedin.feathr.core.configvalidator.typesafe.FeatureDefConfigSemanticValidator;
import com.linkedin.feathr.core.utils.Utils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.json.JSONTokener;

@Deprecated
public class TypesafeConfigValidator
implements ConfigValidator {
    private static final Logger logger = Logger.getLogger(TypesafeConfigValidator.class);
    private ConfigRenderOptions _renderOptions = ConfigRenderOptions.defaults().setComments(false).setOriginComments(false).setFormatted(true).setJson(true);
    private Schema _featureDefSchema;
    private Schema _joinConfigSchema;
    private Schema _presentationConfigSchema;
    private static final String FEATUREDEF_CONFIG_SCHEMA = "/FeatureDefConfigSchema.json";
    private static final String JOIN_CONFIG_SCHEMA = "/JoinConfigSchema.json";
    private static final String PRESENTATION_CONFIG_SCHEMA = "/PresentationsConfigSchema.json";
    private static final String ANCHOR_SOURCE_NAME_REGEX = "(^[a-zA-Z][-\\w]*$)";
    private static final Pattern ANCHOR_SOURCE_NAME_PATTERN = Pattern.compile("(^[a-zA-Z][-\\w]*$)");
    private static final String NAMESPACE = "namespace";
    private static final String NAME = "name";
    private static final String MAJOR = "major";
    private static final String MINOR = "minor";
    public static final String DELIM = "-";
    public static final String TYPED_REF_BNF = String.join((CharSequence)"-", "(namespace", ")?name(", "major", "minor)?");
    private static final String NAMESPACE_REGEX = "(?:(?<namespace>[a-zA-Z][\\w]+)-)?";
    private static final String NAME_REGEX = "(?<name>[a-zA-Z][.:\\w]*)";
    private static final String STRICT_NAME_REGEX = "(?<name>[a-zA-Z][\\w]*)";
    private static final String FEATURE_NAME_REGEX = "([a-zA-Z][.:\\w]*)";
    private static final String VERSION_REGEX = "((?:-(?<major>[\\d]+))(?:-(?<minor>[\\d]+)))?";
    private static final String TYPED_REF_REGEX = "(?:(?<namespace>[a-zA-Z][\\w]+)-)?(?<name>[a-zA-Z][.:\\w]*)((?:-(?<major>[\\d]+))(?:-(?<minor>[\\d]+)))?";
    private static final String STRICT_TYPED_REF_REGEX = "^(?:(?<namespace>[a-zA-Z][\\w]+)-)?(?<name>[a-zA-Z][\\w]*)((?:-(?<major>[\\d]+))(?:-(?<minor>[\\d]+)))?$";
    public static final Pattern STRICT_TYPED_REF_PATTERN = Pattern.compile("^(?:(?<namespace>[a-zA-Z][\\w]+)-)?(?<name>[a-zA-Z][\\w]*)((?:-(?<major>[\\d]+))(?:-(?<minor>[\\d]+)))?$");

    @Override
    public ValidationResult validate(ConfigType configType, ValidationType validationType, ConfigDataProvider configDataProvider) {
        ValidationResult result;
        switch (validationType) {
            case SYNTACTIC: {
                Config config;
                try {
                    config = this.buildTypesafeConfig(configType, configDataProvider);
                }
                catch (ConfigException e) {
                    String details = "Config parsing failed due to invalid HOCON syntax";
                    result = new ValidationResult(ValidationType.SYNTACTIC, ValidationStatus.INVALID, details, e);
                    break;
                }
                result = this.validateSyntax(configType, config);
                break;
            }
            case SEMANTIC: {
                result = this.validateSemantics(configType, configDataProvider);
                break;
            }
            default: {
                throw new ConfigValidationException("Unsupported validation type " + (Object)((Object)validationType));
            }
        }
        logger.info((Object)("Performed " + (Object)((Object)validationType) + " validation for " + (Object)((Object)configType) + " config from " + configDataProvider.getConfigDataInfo()));
        return result;
    }

    @Override
    public Map<ConfigType, ValidationResult> validate(Map<ConfigType, ConfigDataProvider> configTypeWithDataProvider, ValidationType validationType) {
        HashMap<ConfigType, ValidationResult> resultMap = new HashMap<ConfigType, ValidationResult>();
        for (Map.Entry<ConfigType, ConfigDataProvider> entry : configTypeWithDataProvider.entrySet()) {
            ConfigType configType = entry.getKey();
            ConfigDataProvider configDataProvider = entry.getValue();
            ValidationResult result = this.validate(configType, validationType, configDataProvider);
            resultMap.put(configType, result);
        }
        return resultMap;
    }

    public ValidationResult validateSyntax(ConfigType configType, Config config) {
        ValidationResult result;
        try {
            String jsonStr = config.root().render(this._renderOptions);
            JSONTokener tokener = new JSONTokener(jsonStr);
            JSONObject root = new JSONObject(tokener);
            switch (configType) {
                case FeatureDef: {
                    if (this._featureDefSchema == null) {
                        this._featureDefSchema = this.loadFeatureDefSchema();
                        logger.info((Object)"FeatureDef config schema loaded");
                    }
                    this._featureDefSchema.validate((Object)root);
                    result = this.validateFeatureDefNames(config);
                    break;
                }
                case Join: {
                    if (this._joinConfigSchema == null) {
                        this._joinConfigSchema = this.loadJoinConfigSchema();
                        logger.info((Object)"Join config schema loaded");
                    }
                    this._joinConfigSchema.validate((Object)root);
                    result = new ValidationResult(ValidationType.SYNTACTIC, ValidationStatus.VALID);
                    break;
                }
                case Presentation: {
                    if (this._presentationConfigSchema == null) {
                        this._presentationConfigSchema = this.loadPresentationConfigSchema();
                        logger.info((Object)"Presentation config schema loaded");
                    }
                    this._presentationConfigSchema.validate((Object)root);
                    result = new ValidationResult(ValidationType.SYNTACTIC, ValidationStatus.VALID);
                    break;
                }
                default: {
                    throw new ConfigValidationException("Unknown config type: " + (Object)((Object)configType));
                }
            }
        }
        catch (ConfigValidationException e) {
            throw e;
        }
        catch (ValidationException e) {
            String header = (Object)((Object)configType) + " config syntax is invalid. Details:";
            String details = String.join((CharSequence)"\n", header, String.join((CharSequence)"\n", e.getAllMessages()));
            result = new ValidationResult(ValidationType.SYNTACTIC, ValidationStatus.INVALID, details, e);
        }
        catch (Exception e) {
            throw new ConfigValidationException("Config validation error", e);
        }
        logger.debug((Object)("Validated " + (Object)((Object)configType) + " config syntax"));
        return result;
    }

    public ValidationResult validateSemantics(FeatureDefConfig featureDefConfig) {
        return new FeatureDefConfigSemanticValidator().validate(featureDefConfig);
    }

    public ValidationResult validateSemantics(JoinConfig joinConfig, FeatureDefConfig featureDefConfig) {
        throw new ConfigValidationException("Join config semantic validation not yet implemented!");
    }

    private ValidationResult validateSemantics(ConfigType configType, ConfigDataProvider configDataProvider) {
        ValidationResult result;
        switch (configType) {
            case FeatureDef: {
                result = this.validateFeatureDefConfigSemantics(configDataProvider);
                break;
            }
            case Join: {
                result = this.validateJoinConfigSemantics(configDataProvider);
                break;
            }
            default: {
                throw new ConfigValidationException("Unsupported config type " + (Object)((Object)configType));
            }
        }
        return result;
    }

    private ValidationResult validateFeatureDefConfigSemantics(ConfigDataProvider configDataProvider) {
        try {
            TypesafeConfigBuilder typesafeConfigBuilder = new TypesafeConfigBuilder();
            FeatureDefConfig featureDefConfig = typesafeConfigBuilder.buildFeatureDefConfig(configDataProvider);
            return this.validateSemantics(featureDefConfig);
        }
        catch (Throwable e) {
            throw new ConfigValidationException("Fail to perform semantic validation for FeatureDef config with" + configDataProvider.getConfigDataInfo(), e);
        }
    }

    private ValidationResult validateJoinConfigSemantics(ConfigDataProvider configDataProvider) {
        throw new ConfigValidationException("Join config semantic validation not yet implemented!");
    }

    private ValidationResult validateFeatureDefNames(Config config) {
        HashSet<String> definedSourceAnchorNames = new HashSet<String>();
        HashSet<String> definedFeatureNames = new HashSet<String>();
        if (config.hasPath("sources")) {
            definedSourceAnchorNames.addAll(config.getConfig("sources").root().keySet());
        }
        if (config.hasPath("anchors")) {
            Config anchorsCfg = config.getConfig("anchors");
            Set anchorNames = anchorsCfg.root().keySet();
            definedSourceAnchorNames.addAll(anchorNames);
            anchorNames.stream().map(Utils::quote).forEach(quotedName -> definedFeatureNames.addAll(this.getFeatureNamesFromAnchorDef(anchorsCfg.getConfig(quotedName))));
        }
        if (config.hasPath("derivations")) {
            definedFeatureNames.addAll(config.getConfig("derivations").root().keySet());
        }
        definedSourceAnchorNames.removeIf(name -> ANCHOR_SOURCE_NAME_PATTERN.matcher((CharSequence)name).find());
        definedFeatureNames.removeIf(name -> STRICT_TYPED_REF_PATTERN.matcher((CharSequence)name).find());
        return this.constructNamingValidationResult(definedSourceAnchorNames, definedFeatureNames);
    }

    private ValidationResult constructNamingValidationResult(Set<String> invalidSourceAnchorNames, Set<String> invalidFeatureNames) {
        String msg;
        if (invalidFeatureNames.isEmpty() && invalidSourceAnchorNames.isEmpty()) {
            return new ValidationResult(ValidationType.SYNTACTIC, ValidationStatus.VALID);
        }
        StringJoiner sj = new StringJoiner("\n", "", "\n");
        if (!invalidFeatureNames.isEmpty()) {
            msg = String.join((CharSequence)"\n", "The feature references/names in Frame configs must conform to the pattern (shown in BNF syntax): " + TYPED_REF_BNF + ", where the 'name' must conform to the pattern (shown as regex) [a-zA-Z][\\w]+", "The following names violate Frame's feature naming convention: ", String.join((CharSequence)"\n", invalidFeatureNames));
            sj.add(msg);
        }
        if (!invalidSourceAnchorNames.isEmpty()) {
            msg = String.join((CharSequence)"\n", "The source and anchor names in Frame configs follow the pattern (shown as regex) (^[a-zA-Z][-\\w]*$)", "The following names violate Frame's source and anchor naming convention: ", String.join((CharSequence)"\n", invalidSourceAnchorNames));
            sj.add(msg);
        }
        return new ValidationResult(ValidationType.SYNTACTIC, ValidationStatus.WARN, sj.toString());
    }

    private Set<String> getFeatureNamesFromAnchorDef(Config anchorConfig) {
        HashSet<String> featureNames;
        ConfigValue value = anchorConfig.getValue("features");
        ConfigValueType valueType = value.valueType();
        switch (valueType) {
            case LIST: {
                featureNames = new HashSet<String>(anchorConfig.getStringList("features"));
                break;
            }
            case OBJECT: {
                featureNames = anchorConfig.getConfig("features").root().keySet();
                break;
            }
            default: {
                StringBuilder sb = new StringBuilder();
                sb.append("Fail to extract feature names from anchor config. ").append("Expected ").append("features").append(" value type List or Object, got ").append(valueType.toString());
                throw new RuntimeException(sb.toString());
            }
        }
        return featureNames;
    }

    private Config buildTypesafeConfig(ConfigType configType, ConfigDataProvider configDataProvider) {
        TypesafeConfigBuilder builder = new TypesafeConfigBuilder();
        return builder.buildTypesafeConfig(configType, configDataProvider);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Schema loadFeatureDefSchema() {
        try (InputStream inputStream = this.getClass().getResourceAsStream(FEATUREDEF_CONFIG_SCHEMA);){
            JSONObject rawSchema = new JSONObject(new JSONTokener(inputStream));
            Schema schema = SchemaLoader.load((JSONObject)rawSchema);
            return schema;
        }
        catch (Exception e) {
            throw new ConfigValidationException("Error in loading FeatureDef schema", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Schema loadJoinConfigSchema() {
        try (InputStream inputStream = this.getClass().getResourceAsStream(JOIN_CONFIG_SCHEMA);){
            JSONObject rawSchema = new JSONObject(new JSONTokener(inputStream));
            Schema schema = SchemaLoader.load((JSONObject)rawSchema);
            return schema;
        }
        catch (Exception e) {
            throw new ConfigValidationException("Error in loading FeatureDef schema", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Schema loadPresentationConfigSchema() {
        try (InputStream inputStream = this.getClass().getResourceAsStream(PRESENTATION_CONFIG_SCHEMA);){
            JSONObject rawSchema = new JSONObject(new JSONTokener(inputStream));
            Schema schema = SchemaLoader.load((JSONObject)rawSchema);
            return schema;
        }
        catch (Exception e) {
            throw new ConfigValidationException("Error in loading PresentationConfig schema", e);
        }
    }
}

