/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public class MvelInputsResolver {
    private static final MvelInputsResolver INSTANCE = new MvelInputsResolver();

    public static MvelInputsResolver getInstance() {
        return INSTANCE;
    }

    private MvelInputsResolver() {
    }

    public List<String> getInputFeatures(String mvelExpr) {
        List expressions = Arrays.stream(mvelExpr.split(";")).map(String::trim).map(expression -> expression.replaceAll("\\s{2,}", " ")).collect(Collectors.toList());
        Set imports = expressions.stream().map(String::trim).filter(x -> x.startsWith("import ")).collect(Collectors.toSet());
        String rewrittenExpr = String.join((CharSequence)";", expressions);
        for (String mvelImport : imports) {
            List<String> importSplit = Arrays.asList(mvelImport.split("\\."));
            String className = importSplit.get(importSplit.size() - 1);
            rewrittenExpr = rewrittenExpr.replace(mvelImport + ";", "import java.lang.Object;");
            rewrittenExpr = rewrittenExpr.replaceAll(className + ".", "Object.");
        }
        ParserContext parserContext = new ParserContext();
        MVEL.analysisCompile((String)rewrittenExpr, (ParserContext)parserContext);
        ArrayList<String> list = new ArrayList<String>();
        for (String featureName : parserContext.getInputs().keySet()) {
            if ("$".equals(featureName) || featureName.equals("com") || featureName.equals("org")) continue;
            list.add(featureName);
        }
        return list;
    }
}

