/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.utils;

import com.typesafe.config.ConfigUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class Utils {
    private Utils() {
    }

    public static <T> String string(List<T> list, String start, String sep, String end) {
        String mid = list.stream().map(Object::toString).collect(Collectors.joining(sep));
        return start + mid + end;
    }

    public static <T> String string(List<T> list) {
        return Utils.string(list, "[", ", ", "]");
    }

    public static <T> String string(List<T> list, String sep) {
        return Utils.string(list, "[", sep, "]");
    }

    public static <T> String string(Set<T> set, String start, String sep, String end) {
        String mid = set.stream().map(Object::toString).collect(Collectors.joining(sep));
        return start + mid + end;
    }

    public static <T> String string(Set<T> set) {
        return Utils.string(set, "{", ", ", "}");
    }

    public static <T> String string(Set<T> set, String sep) {
        return Utils.string(set, "{", sep, "}");
    }

    public static <K, V> String string(Map<K, V> map, String start, String sep, String end) {
        StringBuilder sb = new StringBuilder();
        sb.append(start);
        map.forEach((k, v) -> sb.append(k.toString()).append(":").append(v.toString()).append(sep));
        sb.append(end);
        return sb.toString();
    }

    public static <K, V> String string(Map<K, V> map) {
        return Utils.string(map, "{", ", ", "}");
    }

    public static <K, V> String string(Map<K, V> map, String sep) {
        return Utils.string(map, "{", sep, "}");
    }

    public static <T> String string(T[] array, String start, String sep, String end) {
        String mid = Arrays.stream(array).map(Object::toString).collect(Collectors.joining(sep));
        return start + mid + end;
    }

    public static <T> String string(T[] array) {
        return Utils.string(array, "[", ", ", "]");
    }

    public static <T> String string(T[] array, String sep) {
        return Utils.string(array, "[", sep, "]");
    }

    public static void require(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void require(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static String quote(String key) {
        return (key.contains(".") || key.contains(":")) && !key.startsWith("\"") && !key.endsWith("\"") ? ConfigUtil.quoteString((String)key) : key;
    }
}

