/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.consumer;

import java.time.LocalDateTime;
import java.util.Objects;

public final class DateTimeRange {
    public static final String START_TIME = "start_time";
    public static final String END_TIME = "end_time";
    private final LocalDateTime _start;
    private final LocalDateTime _end;
    private String _configStr;

    public DateTimeRange(LocalDateTime start, LocalDateTime end) {
        this._start = start;
        this._end = end;
        this.constructConfigStr();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DateTimeRange)) {
            return false;
        }
        DateTimeRange that = (DateTimeRange)o;
        return Objects.equals(this._start, that._start) && Objects.equals(this._end, that._end);
    }

    private void constructConfigStr() {
        StringBuilder sb = new StringBuilder();
        sb.append(START_TIME).append(": ").append(this._start).append("\n").append(END_TIME).append(": ").append(this._end).append("\n");
        this._configStr = sb.toString();
    }

    public String toString() {
        return this._configStr;
    }

    public int hashCode() {
        return Objects.hash(this._start, this._end);
    }

    public LocalDateTime getStart() {
        return this._start;
    }

    public LocalDateTime getEnd() {
        return this._end;
    }
}

