/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.consumer;

import com.linkedin.feathr.core.config.ConfigObj;
import com.linkedin.feathr.core.config.consumer.KeyedFeatures;
import com.linkedin.feathr.core.utils.Utils;
import java.util.List;
import java.util.Objects;

public final class FeatureBagConfig
implements ConfigObj {
    private final List<KeyedFeatures> _keyedFeatures;
    private String _configStr;

    public FeatureBagConfig(List<KeyedFeatures> keyedFeatures) {
        Utils.require(!keyedFeatures.isEmpty(), "List of features to be joined can't be empty");
        this._keyedFeatures = keyedFeatures;
        StringBuilder sb = new StringBuilder();
        sb.append(Utils.string(keyedFeatures, "\n")).append("\n");
        this._configStr = sb.toString();
    }

    public String toString() {
        return this._configStr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FeatureBagConfig)) {
            return false;
        }
        FeatureBagConfig that = (FeatureBagConfig)o;
        return Objects.equals(this._keyedFeatures, that._keyedFeatures);
    }

    public int hashCode() {
        return Objects.hash(this._keyedFeatures);
    }

    public List<KeyedFeatures> getKeyedFeatures() {
        return this._keyedFeatures;
    }
}

