/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.consumer;

import com.linkedin.feathr.core.config.ConfigObj;
import com.linkedin.feathr.core.config.consumer.TimestampColumnConfig;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public class JoinTimeSettingsConfig
implements ConfigObj {
    public static final String TIMESTAMP_COLUMN = "timestampColumn";
    public static final String SIMULATE_TIME_DELAY = "simulateTimeDelay";
    public static final String USE_LATEST_FEATURE_DATA = "useLatestFeatureData";
    private final Optional<TimestampColumnConfig> _timestampColumn;
    private final Optional<Duration> _simulateTimeDelay;
    private final Optional<Boolean> _useLatestFeatureData;
    private String _configStr;

    public JoinTimeSettingsConfig(TimestampColumnConfig timestampColumn, Duration simulateTimeDelay, Boolean useLatestFeatureData) {
        this._timestampColumn = Optional.ofNullable(timestampColumn);
        this._simulateTimeDelay = Optional.ofNullable(simulateTimeDelay);
        this._useLatestFeatureData = Optional.ofNullable(useLatestFeatureData);
        this.constructConfigStr();
    }

    private void constructConfigStr() {
        StringBuilder sb = new StringBuilder();
        this._timestampColumn.ifPresent(t -> sb.append(TIMESTAMP_COLUMN).append(": ").append(t).append("\n"));
        this._simulateTimeDelay.ifPresent(t -> sb.append(SIMULATE_TIME_DELAY).append(": ").append(t).append("\n"));
        this._useLatestFeatureData.ifPresent(t -> sb.append(USE_LATEST_FEATURE_DATA).append(": ").append(t).append("\n"));
        this._configStr = sb.toString();
    }

    public String toString() {
        return this._configStr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JoinTimeSettingsConfig)) {
            return false;
        }
        JoinTimeSettingsConfig that = (JoinTimeSettingsConfig)o;
        return Objects.equals(this._timestampColumn, that._timestampColumn) && Objects.equals(this._simulateTimeDelay, that._simulateTimeDelay) && Objects.equals(this._useLatestFeatureData, that._useLatestFeatureData);
    }

    public int hashCode() {
        return Objects.hash(this._timestampColumn.hashCode(), this._useLatestFeatureData, this._simulateTimeDelay);
    }

    public Optional<TimestampColumnConfig> getTimestampColumn() {
        return this._timestampColumn;
    }

    public Optional<Duration> getSimulateTimeDelay() {
        return this._simulateTimeDelay;
    }

    public Optional<Boolean> getUseLatestFeatureData() {
        return this._useLatestFeatureData;
    }
}

