/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.consumer;

import com.linkedin.feathr.core.config.consumer.DateTimeRange;
import com.linkedin.feathr.core.utils.Utils;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class KeyedFeatures {
    public static final String KEY = "key";
    public static final String FEATURE_LIST = "featureList";
    public static final String START_DATE = "startDate";
    public static final String END_DATE = "endDate";
    public static final String DATE_OFFSET = "dateOffset";
    public static final String NUM_DAYS = "numDays";
    public static final String OVERRIDE_TIME_DELAY = "overrideTimeDelay";
    public static final String TIMESTAMP_FORMAT = "yyyyMMdd";
    private final List<String> _key;
    private final List<String> _features;
    private final Optional<DateTimeRange> _dates;
    private final Optional<Duration> _overrideTimeDelay;
    private String _configStr;

    public KeyedFeatures(List<String> key, List<String> features, DateTimeRange dates, Duration overrideTimeDelay) {
        this._key = key;
        this._features = features;
        this._dates = Optional.ofNullable(dates);
        this._overrideTimeDelay = Optional.ofNullable(overrideTimeDelay);
        this.constructConfigStr();
    }

    private void constructConfigStr() {
        StringBuilder sb = new StringBuilder();
        sb.append(KEY).append(": ").append(Utils.string(this._key)).append("\n").append(FEATURE_LIST).append(": ").append(Utils.string(this._features)).append("\n");
        this._dates.ifPresent(d -> sb.append(START_DATE).append(": ").append(d.getStart()).append("\n").append(END_DATE).append(": ").append(d.getEnd()).append("\n"));
        this._overrideTimeDelay.ifPresent(d -> sb.append(OVERRIDE_TIME_DELAY).append(": ").append(d).append("\n"));
        this._configStr = sb.toString();
    }

    public String toString() {
        return this._configStr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyedFeatures)) {
            return false;
        }
        KeyedFeatures that = (KeyedFeatures)o;
        return Objects.equals(this._key, that._key) && Objects.equals(this._features, that._features) && Objects.equals(this._dates, that._dates) && Objects.equals(this._overrideTimeDelay, that._overrideTimeDelay);
    }

    public int hashCode() {
        return Objects.hash(this._key, this._features, this._dates, this._overrideTimeDelay);
    }

    public List<String> getKey() {
        return this._key;
    }

    public List<String> getFeatures() {
        return this._features;
    }

    public Optional<DateTimeRange> getDates() {
        return this._dates;
    }

    public Optional<Duration> getOverrideTimeDelay() {
        return this._overrideTimeDelay;
    }
}

