/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.anchors;

import com.linkedin.feathr.core.config.producer.anchors.AnchorConfig;
import com.linkedin.feathr.core.config.producer.anchors.FeatureConfig;
import com.linkedin.feathr.core.config.producer.anchors.TypedKey;
import com.linkedin.feathr.core.utils.Utils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public class AnchorConfigWithExtractor
extends AnchorConfig {
    private final Optional<String> _keyExtractor;
    private final Optional<List<String>> _keyAlias;
    private final Optional<TypedKey> _typedKey;
    private final String _extractor;
    private String _configStr;

    public AnchorConfigWithExtractor(String source, String keyExtractor, TypedKey typedKey, List<String> keyAlias, String extractor, Map<String, FeatureConfig> features) {
        super(source, features);
        this._keyExtractor = Optional.ofNullable(keyExtractor);
        this._keyAlias = Optional.ofNullable(keyAlias);
        this._typedKey = Optional.ofNullable(typedKey);
        this._extractor = extractor;
    }

    public AnchorConfigWithExtractor(String source, String keyExtractor, String extractor, Map<String, FeatureConfig> features) {
        this(source, keyExtractor, null, null, extractor, features);
    }

    public AnchorConfigWithExtractor(String source, String extractor, Map<String, FeatureConfig> features) {
        this(source, null, null, null, extractor, features);
    }

    public Optional<String> getKeyExtractor() {
        return this._keyExtractor;
    }

    public Optional<List<String>> getKeyAlias() {
        return this._keyAlias;
    }

    public Optional<TypedKey> getTypedKey() {
        return this._typedKey;
    }

    public String getExtractor() {
        return this._extractor;
    }

    public String toString() {
        if (this._configStr == null) {
            StringJoiner stringJoiner = new StringJoiner("\n");
            stringJoiner.add(String.join((CharSequence)": ", "source", this.getSource())).add(String.join((CharSequence)": ", "extractor", this.getExtractor())).add("features:{\n" + Utils.string(this.getFeatures()) + "\n}");
            this._keyExtractor.ifPresent(ke -> stringJoiner.add(String.join((CharSequence)": ", "keyExtractor", ke)));
            this._keyAlias.ifPresent(ka -> stringJoiner.add(String.join((CharSequence)": ", "keyAlias", Utils.string(ka))));
            this._typedKey.ifPresent(tk -> stringJoiner.add(this._typedKey.toString()));
            this._configStr = stringJoiner.toString();
        }
        return this._configStr;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnchorConfigWithExtractor)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AnchorConfigWithExtractor that = (AnchorConfigWithExtractor)o;
        return Objects.equals(this._extractor, that._extractor) && Objects.equals(this._keyAlias, that._keyAlias) && Objects.equals(this._typedKey, that._typedKey) && Objects.equals(this._keyExtractor, that._keyExtractor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this._extractor, this._keyAlias, this._typedKey, this._keyExtractor);
    }
}

