/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.anchors;

import com.linkedin.feathr.core.config.producer.anchors.FeatureConfig;
import com.linkedin.feathr.core.config.producer.common.FeatureTypeConfig;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.MapUtils;

public final class SimpleFeatureConfig
extends FeatureConfig {
    private final String _featureName;
    private final Map<String, String> _parameters;
    private final Optional<FeatureTypeConfig> _featureTypeConfig;
    private final Optional<String> _defaultValue;
    private String _configStr;

    public SimpleFeatureConfig(String featureName) {
        this(featureName, null, null, Collections.emptyMap());
    }

    public SimpleFeatureConfig(String featureName, FeatureTypeConfig featureTypeConfig) {
        this(featureName, featureTypeConfig, null, Collections.emptyMap());
    }

    public SimpleFeatureConfig(String featureName, FeatureTypeConfig featureTypeConfig, String defaultValue, Map<String, String> parameters) {
        this._featureName = featureName;
        this._featureTypeConfig = Optional.ofNullable(featureTypeConfig);
        this._defaultValue = Optional.ofNullable(defaultValue);
        this._parameters = parameters;
        this.constructConfigStr();
    }

    private void constructConfigStr() {
        StringBuilder sb = new StringBuilder();
        sb.append("def").append(": ").append(this._featureName).append("\n");
        this._featureTypeConfig.ifPresent(t -> sb.append("type").append(": ").append(t).append("\n"));
        this._defaultValue.ifPresent(v -> sb.append("default").append(": ").append((String)v).append("\n"));
        if (MapUtils.isNotEmpty(this._parameters)) {
            sb.append("parameters").append(": {\n");
            this._parameters.entrySet().stream().map(entry -> sb.append(String.format("%s = %s\n", entry.getKey(), entry.getValue())));
            sb.append("}\n");
        }
        this._configStr = sb.toString();
    }

    @Deprecated
    public String getFeatureExpr() {
        return this._featureName;
    }

    public String getFeatureName() {
        return this._featureName;
    }

    @Override
    public Optional<FeatureTypeConfig> getFeatureTypeConfig() {
        return this._featureTypeConfig;
    }

    @Override
    public Optional<String> getDefaultValue() {
        return this._defaultValue;
    }

    @Override
    public Map<String, String> getParameters() {
        return this._parameters;
    }

    public String toString() {
        return this._featureName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleFeatureConfig that = (SimpleFeatureConfig)o;
        return Objects.equals(this._featureName, that._featureName) && Objects.equals(this._featureTypeConfig, that._featureTypeConfig) && Objects.equals(this._defaultValue, that._defaultValue) && Objects.equals(this._parameters, that._parameters);
    }

    public int hashCode() {
        return Objects.hash(this._featureName, this._featureTypeConfig, this._defaultValue, this._parameters);
    }
}

