/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.anchors;

import com.linkedin.feathr.core.config.TimeWindowAggregationType;
import com.linkedin.feathr.core.config.producer.ExprType;
import com.linkedin.feathr.core.config.producer.TypedExpr;
import com.linkedin.feathr.core.config.producer.anchors.FeatureConfig;
import com.linkedin.feathr.core.config.producer.anchors.WindowParametersConfig;
import com.linkedin.feathr.core.config.producer.common.FeatureTypeConfig;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public final class TimeWindowFeatureConfig
extends FeatureConfig {
    private final TypedExpr _typedColumnExpr;
    private final TimeWindowAggregationType _aggregation;
    private final WindowParametersConfig _windowParameters;
    private final Optional<TypedExpr> _typedFilter;
    private final Optional<String> _groupBy;
    private final Optional<Integer> _limit;
    private final Optional<String> _decay;
    private final Optional<String> _weight;
    private final Optional<Integer> _embeddingSize;
    private final Optional<FeatureTypeConfig> _featureTypeConfig;
    private final Optional<String> _defaultValue;
    private String _configStr;

    public TimeWindowFeatureConfig(TypedExpr typedColumnExpr, TimeWindowAggregationType aggregation, WindowParametersConfig windowParameters, TypedExpr typedFilter, String groupBy, Integer limit, String decay, String weight, Integer embeddingSize, FeatureTypeConfig featureTypeConfig, String defaultValue) {
        this._typedColumnExpr = typedColumnExpr;
        this._aggregation = aggregation;
        this._windowParameters = windowParameters;
        this._typedFilter = Optional.ofNullable(typedFilter);
        this._groupBy = Optional.ofNullable(groupBy);
        this._limit = Optional.ofNullable(limit);
        this._decay = Optional.ofNullable(decay);
        this._weight = Optional.ofNullable(weight);
        this._embeddingSize = Optional.ofNullable(embeddingSize);
        this._featureTypeConfig = Optional.ofNullable(featureTypeConfig);
        this._defaultValue = Optional.ofNullable(defaultValue);
        this.constructConfigStr();
    }

    public TimeWindowFeatureConfig(TypedExpr typedColumnExpr, TimeWindowAggregationType aggregation, WindowParametersConfig windowParameters, TypedExpr typedFilter, String groupBy, Integer limit, String decay, String weight, Integer embeddingSize) {
        this(typedColumnExpr, aggregation, windowParameters, typedFilter, groupBy, limit, decay, weight, embeddingSize, null, null);
    }

    public TimeWindowFeatureConfig(String columnExpr, ExprType columnExprType, TimeWindowAggregationType aggregation, WindowParametersConfig windowParameters, String filter, ExprType filterExprType, String groupBy, Integer limit, String decay, String weight) {
        this(new TypedExpr(columnExpr, columnExprType), aggregation, windowParameters, filter == null ? null : new TypedExpr(filter, filterExprType), groupBy, limit, decay, weight, null);
    }

    @Deprecated
    public TimeWindowFeatureConfig(String columnExpr, TimeWindowAggregationType aggregation, WindowParametersConfig windowParameters, String filter, String groupBy, Integer limit, String decay, String weight) {
        this(new TypedExpr(columnExpr, ExprType.SQL), aggregation, windowParameters, filter == null ? null : new TypedExpr(filter, ExprType.SQL), groupBy, limit, decay, weight, null);
    }

    private void constructConfigStr() {
        StringBuilder sb = new StringBuilder();
        sb.append("def").append(": ").append(this._typedColumnExpr.getExpr()).append("\n");
        sb.append("def expr type").append(": ").append((Object)this._typedColumnExpr.getExprType()).append("\n");
        sb.append("aggregation").append(": ").append((Object)this._aggregation).append("\n");
        sb.append("windowParameters").append(": ").append(this._windowParameters).append("\n");
        this._typedFilter.ifPresent(v -> sb.append("filter").append(": ").append(v.getExpr()).append("\n").append("filter expr type").append(": ").append((Object)v.getExprType()).append("\n"));
        this._groupBy.ifPresent(v -> sb.append("groupBy").append(": ").append((String)v).append("\n"));
        this._limit.ifPresent(v -> sb.append("limit").append(": ").append(v).append("\n"));
        this._decay.ifPresent(v -> sb.append("decay").append(": ").append((String)v).append("\n"));
        this._weight.ifPresent(v -> sb.append("weight").append(": ").append((String)v).append("\n"));
        this._embeddingSize.ifPresent(v -> sb.append("embeddingSize").append(": ").append(v).append("\n"));
        this._configStr = sb.toString();
    }

    public String toString() {
        return this._configStr;
    }

    public String getColumnExpr() {
        return this._typedColumnExpr.getExpr();
    }

    public TimeWindowAggregationType getAggregation() {
        return this._aggregation;
    }

    public Duration getWindow() {
        return this._windowParameters.getSize();
    }

    public WindowParametersConfig getWindowParameters() {
        return this._windowParameters;
    }

    public Optional<String> getFilter() {
        return this._typedFilter.map(TypedExpr::getExpr);
    }

    public Optional<String> getGroupBy() {
        return this._groupBy;
    }

    public Optional<Integer> getLimit() {
        return this._limit;
    }

    public Optional<String> getDecay() {
        return this._decay;
    }

    public Optional<String> getWeight() {
        return this._weight;
    }

    public ExprType getColumnExprType() {
        return this._typedColumnExpr.getExprType();
    }

    public Optional<ExprType> getFilterExprType() {
        return this._typedFilter.map(TypedExpr::getExprType);
    }

    public TypedExpr getTypedColumnExpr() {
        return this._typedColumnExpr;
    }

    public Optional<TypedExpr> getTypedFilter() {
        return this._typedFilter;
    }

    public Optional<Integer> getEmbeddingSize() {
        return this._embeddingSize;
    }

    @Override
    public Optional<String> getDefaultValue() {
        return this._defaultValue;
    }

    @Override
    public Optional<FeatureTypeConfig> getFeatureTypeConfig() {
        return this._featureTypeConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeWindowFeatureConfig that = (TimeWindowFeatureConfig)o;
        return Objects.equals(this._typedColumnExpr, that._typedColumnExpr) && this._aggregation == that._aggregation && Objects.equals(this._windowParameters, that._windowParameters) && Objects.equals(this._typedFilter, that._typedFilter) && Objects.equals(this._groupBy, that._groupBy) && Objects.equals(this._limit, that._limit) && Objects.equals(this._decay, that._decay) && Objects.equals(this._weight, that._weight) && Objects.equals(this._embeddingSize, that._embeddingSize) && Objects.equals(this._featureTypeConfig, that._featureTypeConfig) && Objects.equals(this._defaultValue, that._defaultValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._typedColumnExpr, this._aggregation, this._windowParameters, this._typedFilter, this._groupBy, this._limit, this._decay, this._weight, this._embeddingSize, this._featureTypeConfig, this._defaultValue});
    }
}

