/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.anchors;

import com.linkedin.feathr.core.config.producer.ExprType;
import com.linkedin.feathr.core.config.producer.common.KeyListExtractor;
import com.linkedin.feathr.core.utils.Utils;
import java.util.List;
import java.util.Objects;

public class TypedKey {
    private final String _rawKeyExpr;
    private final List<String> _key;
    private final ExprType _keyExprType;
    private String _configStr;

    public TypedKey(String rawKeyExpr, ExprType keyExprType) {
        this._rawKeyExpr = rawKeyExpr;
        this._key = KeyListExtractor.getInstance().extractFromHocon(rawKeyExpr);
        this._keyExprType = keyExprType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypedKey)) {
            return false;
        }
        TypedKey typedKey = (TypedKey)o;
        return Objects.equals(this._key, typedKey._key) && this._keyExprType == typedKey._keyExprType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._rawKeyExpr, this._key, this._keyExprType});
    }

    public String toString() {
        if (this._configStr == null) {
            this._configStr = String.join((CharSequence)"\n", String.join((CharSequence)": ", "raw key expression", this._rawKeyExpr), String.join((CharSequence)": ", "key", this._key.size() == 1 ? (CharSequence)this._key.get(0) : Utils.string(this._key)), String.join((CharSequence)": ", "key expression type", this._keyExprType.toString()));
        }
        return this._configStr;
    }

    public List<String> getKey() {
        return this._key;
    }

    public ExprType getKeyExprType() {
        return this._keyExprType;
    }

    public String getRawKeyExpr() {
        return this._rawKeyExpr;
    }
}

