/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.anchors;

import com.linkedin.feathr.core.config.WindowType;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public class WindowParametersConfig {
    private final WindowType _windowType;
    private final Duration _size;
    private final Optional<Duration> _slidingInterval;
    private String _configStr;

    public WindowParametersConfig(WindowType windowType, Duration size, Duration slidingInterval) {
        this._windowType = windowType;
        this._size = size;
        this._slidingInterval = Optional.ofNullable(slidingInterval);
        this.constructConfigStr();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WindowParametersConfig)) {
            return false;
        }
        WindowParametersConfig that = (WindowParametersConfig)o;
        return Objects.equals((Object)this._windowType, (Object)that._windowType) && Objects.equals(this._size, that._size) && Objects.equals(this._slidingInterval, that._slidingInterval);
    }

    private void constructConfigStr() {
        StringBuilder sb = new StringBuilder();
        sb.append("type").append(": ").append((Object)this._windowType).append("\n").append("size").append(": ").append(this._size).append("\n");
        this._slidingInterval.ifPresent(d -> sb.append("slidingInterval").append(": ").append(d).append("\n"));
        this._configStr = sb.toString();
    }

    public String toString() {
        return this._configStr;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._windowType, this._size, this._slidingInterval});
    }

    public WindowType getWindowType() {
        return this._windowType;
    }

    public Duration getSize() {
        return this._size;
    }

    public Optional<Duration> getSlidingInterval() {
        return this._slidingInterval;
    }
}

