/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.common;

import com.linkedin.feathr.core.config.ConfigObj;
import com.linkedin.feathr.core.config.producer.definitions.FeatureType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public class FeatureTypeConfig
implements ConfigObj {
    public static final String TYPE = "type";
    public static final String TENSOR_CATEGORY = "tensorCategory";
    public static final String SHAPE = "shape";
    public static final String DIMENSION_TYPE = "dimensionType";
    public static final String VAL_TYPE = "valType";
    private final FeatureType _featureType;
    private final Optional<List<Integer>> _shapes;
    private final Optional<List<String>> _dimensionTypes;
    private final Optional<String> _valType;
    private String _configStr;

    private FeatureTypeConfig(@NonNull FeatureType featureType, List<Integer> shapes, List<String> dimensionTypes, String valType) {
        this._featureType = featureType == FeatureType.VECTOR ? FeatureType.DENSE_VECTOR : featureType;
        this._shapes = Optional.ofNullable(shapes);
        this._dimensionTypes = Optional.ofNullable(dimensionTypes);
        this._valType = Optional.ofNullable(valType);
        this.constructConfigStr();
    }

    public FeatureTypeConfig(@NonNull FeatureType featureType) {
        this(featureType, null, null, null);
    }

    public FeatureType getFeatureType() {
        return this._featureType;
    }

    private void constructConfigStr() {
        StringBuilder sb = new StringBuilder();
        sb.append(TYPE).append(": ").append((Object)this._featureType).append("\n");
        this._shapes.ifPresent(t -> sb.append(SHAPE).append(": ").append(t).append("\n"));
        this._dimensionTypes.ifPresent(v -> sb.append(DIMENSION_TYPE).append(": ").append(v).append("\n"));
        this._valType.ifPresent(v -> sb.append(VAL_TYPE).append(": ").append((String)v).append("\n"));
        this._configStr = sb.toString();
    }

    public Optional<List<Integer>> getShapes() {
        return this._shapes;
    }

    public Optional<List<String>> getDimensionTypes() {
        return this._dimensionTypes;
    }

    public Optional<String> getValType() {
        return this._valType;
    }

    public String getConfigStr() {
        return this._configStr;
    }

    public String toString() {
        return this._configStr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureTypeConfig that = (FeatureTypeConfig)o;
        return this._featureType == that._featureType && Objects.equals(this._shapes, that._shapes) && Objects.equals(this._dimensionTypes, that._dimensionTypes) && Objects.equals(this._valType, that._valType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._featureType, this._shapes, this._dimensionTypes, this._valType});
    }

    public static class Builder {
        private FeatureType _featureType;
        private List<Integer> _shapes;
        private List<String> _dimensionTypes;
        private String _valType;

        public Builder setFeatureType(FeatureType featureType) {
            this._featureType = featureType;
            return this;
        }

        public Builder setShapes(List<Integer> shapes) {
            this._shapes = shapes;
            return this;
        }

        public Builder setDimensionTypes(List<String> dimensionTypes) {
            this._dimensionTypes = dimensionTypes;
            return this;
        }

        public Builder setValType(String valType) {
            this._valType = valType;
            return this;
        }

        public FeatureTypeConfig build() {
            return new FeatureTypeConfig(this._featureType, this._shapes, this._dimensionTypes, this._valType);
        }
    }
}

