/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.derivations;

import com.linkedin.feathr.core.config.producer.ExprType;
import com.linkedin.feathr.core.config.producer.TypedExpr;
import com.linkedin.feathr.core.config.producer.common.FeatureTypeConfig;
import com.linkedin.feathr.core.config.producer.derivations.DerivationConfig;
import com.linkedin.feathr.core.config.producer.derivations.KeyedFeature;
import com.linkedin.feathr.core.utils.Utils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class DerivationConfigWithExpr
implements DerivationConfig {
    private final List<String> _keys;
    private final Map<String, KeyedFeature> _inputs;
    private final TypedExpr _typedDefinition;
    private final Optional<FeatureTypeConfig> _featureTypeConfig;
    private String _configStr;

    public DerivationConfigWithExpr(List<String> keys, Map<String, KeyedFeature> inputs, TypedExpr typedDefinition) {
        this._keys = keys;
        this._inputs = inputs;
        this._typedDefinition = typedDefinition;
        this._featureTypeConfig = Optional.empty();
    }

    public DerivationConfigWithExpr(List<String> keys, Map<String, KeyedFeature> inputs, TypedExpr typedDefinition, FeatureTypeConfig featureTypeConfig) {
        this._keys = keys;
        this._inputs = inputs;
        this._typedDefinition = typedDefinition;
        this._featureTypeConfig = Optional.ofNullable(featureTypeConfig);
    }

    @Deprecated
    public DerivationConfigWithExpr(List<String> keys, Map<String, KeyedFeature> inputs, String definition) {
        this._keys = keys;
        this._inputs = inputs;
        this._typedDefinition = new TypedExpr(definition, ExprType.MVEL);
        this._featureTypeConfig = Optional.empty();
    }

    public List<String> getKeys() {
        return this._keys;
    }

    public Map<String, KeyedFeature> getInputs() {
        return this._inputs;
    }

    @Deprecated
    public String getDefinition() {
        return this._typedDefinition.getExpr();
    }

    public TypedExpr getTypedDefinition() {
        return this._typedDefinition;
    }

    @Override
    public Optional<FeatureTypeConfig> getFeatureTypeConfig() {
        return this._featureTypeConfig;
    }

    public String toString() {
        if (this._configStr == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("key").append(": ").append(Utils.string(this._keys)).append("\n").append("inputs").append(": ").append(Utils.string(this._inputs, "\n")).append("\n").append("definition").append(": \n").append(this._typedDefinition.toString()).append("\n");
            this._configStr = sb.toString();
        }
        return this._configStr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DerivationConfigWithExpr that = (DerivationConfigWithExpr)o;
        return Objects.equals(this._keys, that._keys) && Objects.equals(this._inputs, that._inputs) && Objects.equals(this._typedDefinition, that._typedDefinition) && Objects.equals(this._featureTypeConfig, that._featureTypeConfig);
    }

    public int hashCode() {
        return Objects.hash(this._keys, this._inputs, this._typedDefinition, this._featureTypeConfig);
    }
}

