/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.derivations;

import com.linkedin.feathr.core.config.producer.common.KeyListExtractor;
import java.util.List;
import java.util.Objects;

public class KeyedFeature {
    private final String _rawKeyExpr;
    private final List<String> _key;
    private final String _feature;
    private String _configStr;

    public KeyedFeature(String rawKeyExpr, String feature) {
        this._rawKeyExpr = rawKeyExpr;
        this._key = KeyListExtractor.getInstance().extractFromHocon(rawKeyExpr);
        this._feature = feature;
        StringBuilder sb = new StringBuilder();
        sb.append("key").append(": ").append(rawKeyExpr).append(", ").append("feature").append(": ").append(feature);
        this._configStr = sb.toString();
    }

    public String toString() {
        return this._configStr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyedFeature)) {
            return false;
        }
        KeyedFeature that = (KeyedFeature)o;
        return Objects.equals(this._key, that._key) && Objects.equals(this._feature, that._feature);
    }

    public int hashCode() {
        return Objects.hash(this._rawKeyExpr, this._key, this._feature);
    }

    public String getRawKeyExpr() {
        return this._rawKeyExpr;
    }

    public List<String> getKey() {
        return this._key;
    }

    public String getFeature() {
        return this._feature;
    }
}

