/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.sources;

import com.linkedin.feathr.core.config.producer.sources.SourceConfig;
import com.linkedin.feathr.core.config.producer.sources.SourceType;
import java.util.Objects;
import java.util.Optional;

public abstract class HdfsConfig
extends SourceConfig {
    private final String _path;
    private final Optional<String> _timePartitionPattern;
    public static final String PATH = "location.path";
    public static final String HAS_TIME_SNAPSHOT = "hasTimeSnapshot";
    public static final String TIME_PARTITION_PATTERN = "timePartitionPattern";

    protected HdfsConfig(String sourceName, String path, String timePartitionPattern) {
        super(sourceName);
        this._path = path;
        this._timePartitionPattern = Optional.ofNullable(timePartitionPattern);
    }

    protected HdfsConfig(String sourceName, String path) {
        this(sourceName, path, null);
    }

    public String getPath() {
        return this._path;
    }

    public Optional<String> getTimePartitionPattern() {
        return this._timePartitionPattern;
    }

    @Override
    public SourceType getSourceType() {
        return SourceType.HDFS;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HdfsConfig that = (HdfsConfig)o;
        return Objects.equals(this._path, that._path) && Objects.equals(this._timePartitionPattern, that._timePartitionPattern);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this._path, this._timePartitionPattern);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HdfsConfig{");
        sb.append("_path='").append(this._path).append('\'');
        sb.append(", _timePartitionPattern=").append(this._timePartitionPattern);
        sb.append(", _sourceName='").append(this._sourceName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

