/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.sources;

import com.linkedin.feathr.core.config.producer.sources.SourceConfig;
import com.linkedin.feathr.core.config.producer.sources.SourceType;
import java.util.Objects;
import java.util.Optional;

public final class PassThroughConfig
extends SourceConfig {
    private final String _dataModel;
    public static final String DATA_MODEL = "dataModel";

    public PassThroughConfig(String sourceName, String dataModel) {
        super(sourceName);
        this._dataModel = dataModel;
    }

    @Override
    public SourceType getSourceType() {
        return SourceType.PASSTHROUGH;
    }

    public Optional<String> getDataModel() {
        return Optional.ofNullable(this._dataModel);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PassThroughConfig that = (PassThroughConfig)o;
        return Objects.equals(this._dataModel, that._dataModel);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this._dataModel);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PassThroughConfig{");
        sb.append("_dataModel='").append(this._dataModel).append('\'');
        sb.append(", _sourceName='").append(this._sourceName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

