/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.sources;

import com.google.common.base.Preconditions;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.feathr.core.config.producer.sources.SourceConfig;
import com.linkedin.feathr.core.config.producer.sources.SourceType;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class RestliConfig
extends SourceConfig {
    public static final String RESOURCE_NAME = "restResourceName";
    @Deprecated
    public static final String RESOUCE_NAME = "restResouceName";
    public static final String KEY_EXPR = "keyExpr";
    @Deprecated
    public static final String ENTITY_TYPE = "restEntityType";
    public static final String REQ_PARAMS = "restReqParams";
    public static final String PATH_SPEC = "pathSpec";
    public static final String FINDER = "finder";
    public static final String JSON = "json";
    public static final String JSON_ARRAY = "jsonArray";
    public static final String JSON_ARRAY_ARRAY = "array";
    public static final String MVEL_KEY = "mvel";
    public static final String FILE = "file";
    private final String _resourceName;
    private final Optional<String> _keyExpr;
    private final Optional<Map<String, Object>> _reqParams;
    private final Optional<PathSpec> _pathSpec;
    private final Optional<String> _finder;

    public RestliConfig(@Nonnull String sourceName, @Nonnull String resourceName, @Nonnull String keyExpr, Map<String, Object> reqParams, PathSpec pathSpec) {
        this(sourceName, resourceName, keyExpr, reqParams, pathSpec, null);
    }

    public RestliConfig(@Nonnull String sourceName, @Nonnull String resourceName, Map<String, Object> reqParams, PathSpec pathSpec, @Nonnull String finder) {
        this(sourceName, resourceName, null, reqParams, pathSpec, finder);
    }

    public RestliConfig(String sourceName, String resourceName, String keyExpr, Map<String, Object> reqParams, PathSpec pathSpec, String finder) {
        super(sourceName);
        Preconditions.checkArgument((keyExpr != null || finder != null ? 1 : 0) != 0, (Object)"Either keyExpr or finder must be present for a RestLi source");
        this._resourceName = resourceName;
        this._keyExpr = Optional.ofNullable(keyExpr);
        this._reqParams = Optional.ofNullable(reqParams);
        this._pathSpec = Optional.ofNullable(pathSpec);
        this._finder = Optional.ofNullable(finder);
    }

    public String getResourceName() {
        return this._resourceName;
    }

    @Deprecated
    public String getKeyExpr() {
        return this._keyExpr.orElse(null);
    }

    public Optional<String> getOptionalKeyExpr() {
        return this._keyExpr;
    }

    public Optional<Map<String, Object>> getReqParams() {
        return this._reqParams;
    }

    public Optional<PathSpec> getPathSpec() {
        return this._pathSpec;
    }

    public Optional<String> getFinder() {
        return this._finder;
    }

    @Override
    public SourceType getSourceType() {
        return SourceType.RESTLI;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RestliConfig that = (RestliConfig)o;
        return Objects.equals(this._resourceName, that._resourceName) && Objects.equals(this._keyExpr, that._keyExpr) && Objects.equals(this._reqParams, that._reqParams) && Objects.equals(this._pathSpec, that._pathSpec) && Objects.equals(this._finder, that._finder);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this._resourceName, this._keyExpr, this._reqParams, this._pathSpec, this._finder);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RestliConfig{");
        sb.append("_resourceName='").append(this._resourceName).append('\'');
        sb.append(", _keyExpr=").append(this._keyExpr);
        sb.append(", _reqParams=").append(this._reqParams);
        sb.append(", _pathSpec=").append(this._pathSpec);
        sb.append(", _finder=").append(this._finder);
        sb.append(", _sourceName='").append(this._sourceName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

