/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.config.producer.sources;

import com.linkedin.feathr.core.config.producer.sources.SourceConfig;
import com.linkedin.feathr.core.config.producer.sources.SourceType;
import java.util.Objects;
import java.util.Optional;

public final class RocksDbConfig
extends SourceConfig {
    public static final String REFERENCE_SOURCE = "referenceSource";
    public static final String EXTRACT_FEATURES = "extractFeatures";
    public static final String ENCODER = "encoder";
    public static final String DECODER = "decoder";
    public static final String KEYEXPR = "keyExpr";
    private final String _referenceSource;
    private final Boolean _extractFeatures;
    private final Optional<String> _encoder;
    private final Optional<String> _decoder;
    private final Optional<String> _keyExpr;

    public RocksDbConfig(String sourceName, String referenceSource, Boolean extractFeatures, String encoder, String decoder, String keyExpr) {
        super(sourceName);
        this._referenceSource = referenceSource;
        this._extractFeatures = extractFeatures;
        this._encoder = Optional.ofNullable(encoder);
        this._decoder = Optional.ofNullable(decoder);
        this._keyExpr = Optional.ofNullable(keyExpr);
    }

    @Deprecated
    public RocksDbConfig(String sourceName, String referenceSource, Boolean extractFeatures, String encoder, String decoder) {
        super(sourceName);
        this._referenceSource = referenceSource;
        this._extractFeatures = extractFeatures;
        this._encoder = Optional.ofNullable(encoder);
        this._decoder = Optional.ofNullable(decoder);
        this._keyExpr = Optional.empty();
    }

    public String getReferenceSource() {
        return this._referenceSource;
    }

    public Boolean getExtractFeatures() {
        return this._extractFeatures;
    }

    public Optional<String> getEncoder() {
        return this._encoder;
    }

    public Optional<String> getDecoder() {
        return this._decoder;
    }

    public Optional<String> getKeyExpr() {
        return this._keyExpr;
    }

    @Override
    public SourceType getSourceType() {
        return SourceType.ROCKSDB;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RocksDbConfig that = (RocksDbConfig)o;
        return Objects.equals(this._referenceSource, that._referenceSource) && Objects.equals(this._extractFeatures, that._extractFeatures) && Objects.equals(this._encoder, that._encoder) && Objects.equals(this._decoder, that._decoder) && Objects.equals(this._keyExpr, that._keyExpr);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this._referenceSource, this._extractFeatures, this._encoder, this._decoder, this._keyExpr);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RocksDbConfig{");
        sb.append("_referenceSource='").append(this._referenceSource).append('\'');
        sb.append(", _extractFeatures=").append(this._extractFeatures);
        sb.append(", _encoder=").append(this._encoder);
        sb.append(", _decoder=").append(this._decoder);
        sb.append(", _keyExpr=").append(this._keyExpr);
        sb.append(", _sourceName='").append(this._sourceName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

