/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe;

import com.linkedin.feathr.core.config.ConfigType;
import com.linkedin.feathr.core.config.consumer.JoinConfig;
import com.linkedin.feathr.core.config.producer.FeatureDefConfig;
import com.linkedin.feathr.core.configbuilder.ConfigBuilder;
import com.linkedin.feathr.core.configbuilder.ConfigBuilderException;
import com.linkedin.feathr.core.configbuilder.typesafe.consumer.JoinConfigBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.FeatureDefConfigBuilder;
import com.linkedin.feathr.core.configdataprovider.ConfigDataProvider;
import com.linkedin.feathr.core.configdataprovider.ConfigDataProviderException;
import com.linkedin.feathr.core.configdataprovider.ManifestConfigDataProvider;
import com.linkedin.feathr.core.configdataprovider.ReaderConfigDataProvider;
import com.linkedin.feathr.core.configdataprovider.ResourceConfigDataProvider;
import com.linkedin.feathr.core.configdataprovider.StringConfigDataProvider;
import com.linkedin.feathr.core.configdataprovider.UrlConfigDataProvider;
import com.linkedin.feathr.core.configvalidator.ValidationResult;
import com.linkedin.feathr.core.configvalidator.ValidationStatus;
import com.linkedin.feathr.core.configvalidator.typesafe.TypesafeConfigValidator;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigSyntax;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypesafeConfigBuilder
implements ConfigBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TypesafeConfigBuilder.class);
    private ConfigParseOptions _parseOptions = ConfigParseOptions.defaults().setSyntax(ConfigSyntax.CONF).setAllowMissing(false);
    private ConfigRenderOptions _renderOptions = ConfigRenderOptions.defaults().setComments(false).setOriginComments(false).setFormatted(true).setJson(true);

    @Override
    public FeatureDefConfig buildFeatureDefConfig(ConfigDataProvider configDataProvider) {
        FeatureDefConfig configObj;
        Objects.requireNonNull(configDataProvider, "ConfigDataProvider object can't be null");
        try {
            List<Reader> readers = configDataProvider.getConfigDataReaders();
            configObj = this.doBuildFeatureDefConfig(readers);
        }
        catch (Exception e) {
            throw new ConfigBuilderException("Error in building FeatureDefConfig object", e);
        }
        logger.info("Built FeatureDefConfig from " + configDataProvider.getConfigDataInfo());
        return configObj;
    }

    @Override
    public List<FeatureDefConfig> buildFeatureDefConfigList(ConfigDataProvider configDataProvider) {
        Objects.requireNonNull(configDataProvider, "ConfigDataProvider object can't be null");
        ArrayList<FeatureDefConfig> featureDefConfigList = new ArrayList<FeatureDefConfig>();
        try {
            List<Reader> readers = configDataProvider.getConfigDataReaders();
            for (Reader reader : readers) {
                List<Reader> singletonReaderList = Collections.singletonList(reader);
                FeatureDefConfig configObj = this.doBuildFeatureDefConfig(singletonReaderList);
                featureDefConfigList.add(configObj);
            }
        }
        catch (ConfigBuilderException e) {
            throw new ConfigBuilderException("Error in building FeatureDefConfig object", e);
        }
        if (featureDefConfigList.isEmpty()) {
            logger.warn("No FeatureDefConfigs were built after entering buildFeatureDefConfigList(). ConfigDataProvider Info:" + configDataProvider.getConfigDataInfo());
        } else {
            logger.info("Built FeatureDefConfig from " + configDataProvider.getConfigDataInfo());
        }
        return featureDefConfigList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Deprecated
    public FeatureDefConfig buildFeatureDefConfigFromUrls(List<URL> urls) {
        try (UrlConfigDataProvider cdp = new UrlConfigDataProvider(urls);){
            FeatureDefConfig featureDefConfig = this.buildFeatureDefConfig(cdp);
            return featureDefConfig;
        }
        catch (Exception e) {
            throw new ConfigBuilderException("Error in building FeatureDefConfig object", e);
        }
    }

    @Override
    @Deprecated
    public FeatureDefConfig buildFeatureDefConfig(URL url) {
        return this.buildFeatureDefConfigFromUrls(Collections.singletonList(url));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Deprecated
    public FeatureDefConfig buildFeatureDefConfig(List<String> resourceNames) {
        try (ResourceConfigDataProvider cdp = new ResourceConfigDataProvider(resourceNames);){
            FeatureDefConfig featureDefConfig = this.buildFeatureDefConfig(cdp);
            return featureDefConfig;
        }
        catch (Exception e) {
            throw new ConfigBuilderException("Error in building FeatureDefConfig object", e);
        }
    }

    @Override
    @Deprecated
    public FeatureDefConfig buildFeatureDefConfig(String resourceName) {
        return this.buildFeatureDefConfig(Collections.singletonList(resourceName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Deprecated
    public FeatureDefConfig buildFeatureDefConfigFromString(String configStr) {
        try (StringConfigDataProvider cdp = new StringConfigDataProvider(configStr);){
            FeatureDefConfig featureDefConfig = this.buildFeatureDefConfig(cdp);
            return featureDefConfig;
        }
        catch (Exception e) {
            throw new ConfigBuilderException("Error in building FeatureDefConfig object", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Deprecated
    public FeatureDefConfig buildFeatureDefConfig(Reader reader) {
        try (ReaderConfigDataProvider cdp = new ReaderConfigDataProvider(reader);){
            FeatureDefConfig featureDefConfig = this.buildFeatureDefConfig(cdp);
            return featureDefConfig;
        }
        catch (Exception e) {
            throw new ConfigBuilderException("Error in building FeatureDefConfig object", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Deprecated
    public FeatureDefConfig buildFeatureDefConfigFromManifest(String manifestResourceName) {
        try (ManifestConfigDataProvider cdp = new ManifestConfigDataProvider(manifestResourceName);){
            FeatureDefConfig featureDefConfig = this.buildFeatureDefConfig(cdp);
            return featureDefConfig;
        }
        catch (Exception e) {
            throw new ConfigBuilderException("Error in building FeatureDefConfig object from manifest resource " + manifestResourceName, e);
        }
    }

    @Override
    public JoinConfig buildJoinConfig(ConfigDataProvider configDataProvider) {
        JoinConfig configObj;
        Objects.requireNonNull(configDataProvider, "ConfigDataProvider object can't be null");
        try {
            List<Reader> readers = configDataProvider.getConfigDataReaders();
            if (readers.size() != 1) {
                throw new ConfigDataProviderException("Expected number of Join configs = 1, found " + readers.size());
            }
            configObj = this.doBuildJoinConfig(readers.get(0));
        }
        catch (Exception e) {
            throw new ConfigBuilderException("Error in building JoinConfig object", e);
        }
        logger.info("Built JoinConfig from " + configDataProvider.getConfigDataInfo());
        return configObj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Deprecated
    public JoinConfig buildJoinConfig(URL url) {
        try (UrlConfigDataProvider cdp = new UrlConfigDataProvider(url);){
            JoinConfig joinConfig = this.buildJoinConfig(cdp);
            return joinConfig;
        }
        catch (Exception e) {
            throw new ConfigBuilderException("Error in building JoinConfig object from URL " + url, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Deprecated
    public JoinConfig buildJoinConfig(String resourceName) {
        try (ResourceConfigDataProvider cdp = new ResourceConfigDataProvider(resourceName);){
            JoinConfig joinConfig = this.buildJoinConfig(cdp);
            return joinConfig;
        }
        catch (Exception e) {
            throw new ConfigBuilderException("Error in building JoinConfig object from resource " + resourceName, e);
        }
    }

    public Config buildTypesafeConfig(ConfigType configType, ConfigDataProvider configDataProvider) {
        Config config;
        List<Reader> readers = configDataProvider.getConfigDataReaders();
        switch (configType) {
            case FeatureDef: {
                config = this.buildMergedConfig(readers);
                break;
            }
            case Join: 
            case Presentation: {
                if (readers.size() != 1) {
                    throw new ConfigDataProviderException("Expected number of " + (Object)((Object)configType) + " configs = 1, found " + readers.size());
                }
                config = ConfigFactory.parseReader((Reader)readers.get(0), (ConfigParseOptions)this._parseOptions);
                break;
            }
            default: {
                throw new ConfigBuilderException("Unsupported config type " + (Object)((Object)configType));
            }
        }
        logger.debug((Object)((Object)configType) + " config: \n" + config.root().render(this._renderOptions.setJson(false)));
        return config;
    }

    private FeatureDefConfig doBuildFeatureDefConfig(List<Reader> readers) {
        Config mergedConfig = this.buildMergedConfig(readers);
        logger.debug("FeatureDef config: \n" + mergedConfig.root().render(this._renderOptions.setJson(false)));
        this.validate(mergedConfig, ConfigType.FeatureDef);
        return FeatureDefConfigBuilder.build(mergedConfig);
    }

    private Config buildMergedConfig(List<Reader> readers) {
        Config emptyConfig = ConfigFactory.empty();
        return readers.stream().map(r -> ConfigFactory.parseReader((Reader)r, (ConfigParseOptions)this._parseOptions)).map(Config::resolve).reduce(emptyConfig, Config::withFallback);
    }

    private JoinConfig doBuildJoinConfig(Reader reader) {
        Config config = ConfigFactory.parseReader((Reader)reader, (ConfigParseOptions)this._parseOptions);
        logger.debug("Join config: \n" + config.root().render(this._renderOptions.setJson(false)));
        this.validate(config, ConfigType.Join);
        return JoinConfigBuilder.build(config);
    }

    private void validate(Config config, ConfigType configType) {
        TypesafeConfigValidator validator = new TypesafeConfigValidator();
        ValidationResult validationResult = validator.validateSyntax(configType, config);
        logger.debug("Performed syntax validation for " + (Object)((Object)configType) + " config. Result: " + validationResult);
        if (validationResult.getValidationStatus() == ValidationStatus.INVALID) {
            String errMsg = validationResult.getDetails().orElse((Object)((Object)configType) + " config syntax validation failed");
            if (validationResult.getCause().isPresent()) {
                throw new ConfigBuilderException(errMsg, validationResult.getCause().get());
            }
            throw new ConfigBuilderException(errMsg);
        }
    }
}

