/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.consumer;

import com.linkedin.feathr.core.config.consumer.JoinTimeSettingsConfig;
import com.linkedin.feathr.core.config.consumer.TimestampColumnConfig;
import com.linkedin.feathr.core.configbuilder.ConfigBuilderException;
import com.linkedin.feathr.core.configbuilder.typesafe.consumer.TimestampColumnConfigBuilder;
import com.typesafe.config.Config;
import java.time.Duration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class JoinTimeSettingsConfigBuilder {
    private static final Logger logger = LogManager.getLogger(JoinTimeSettingsConfigBuilder.class);

    private JoinTimeSettingsConfigBuilder() {
    }

    public static JoinTimeSettingsConfig build(Config joinTimSettingsConfig) {
        Boolean useLatestFeatureData;
        TimestampColumnConfig timestampColumn = joinTimSettingsConfig.hasPath("timestampColumn") ? TimestampColumnConfigBuilder.build(joinTimSettingsConfig.getConfig("timestampColumn")) : null;
        Duration simulateTimeDelay = joinTimSettingsConfig.hasPath("simulateTimeDelay") ? joinTimSettingsConfig.getDuration("simulateTimeDelay") : null;
        Boolean bl = useLatestFeatureData = joinTimSettingsConfig.hasPath("useLatestFeatureData") ? Boolean.valueOf(joinTimSettingsConfig.getBoolean("useLatestFeatureData")) : null;
        if (timestampColumn == null && useLatestFeatureData == null) {
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append("One of the fields: ").append("timestampColumn").append(" or ").append("useLatestFeatureData").append("is required but both are missing");
            throw new ConfigBuilderException(messageBuilder.toString());
        }
        if (useLatestFeatureData != null && useLatestFeatureData.booleanValue() && (timestampColumn != null || simulateTimeDelay != null)) {
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append("When ").append("useLatestFeatureData").append(" is set to true, ").append("None of the following fields can exist: ").append("timestampColumn").append(", ").append("simulateTimeDelay").append(".");
            throw new ConfigBuilderException(messageBuilder.toString());
        }
        JoinTimeSettingsConfig configObj = new JoinTimeSettingsConfig(timestampColumn, simulateTimeDelay, useLatestFeatureData);
        logger.debug("Built TimeWindowJoinConfig object");
        return configObj;
    }
}

