/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.generation;

import com.linkedin.feathr.core.config.common.OutputFormat;
import com.linkedin.feathr.core.config.generation.OutputProcessorConfig;
import com.typesafe.config.Config;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutputProcessorBuilder {
    private static final Logger logger = LogManager.getLogger(OutputProcessorBuilder.class);
    private static final String OUTPUT_FORMAT = "outputFormat";
    private static final String PARAMS = "params";
    private static final String NAME = "name";

    private OutputProcessorBuilder() {
    }

    public static OutputProcessorConfig build(Config config) {
        String name = config.getString(NAME);
        OutputFormat outputFormat = OutputFormat.valueOf(config.getString(OUTPUT_FORMAT));
        Config params = config.getConfig(PARAMS);
        logger.trace("Built OperationalConfig object");
        return new OutputProcessorConfig(name, outputFormat, params);
    }

    public static OutputProcessorConfig build(String name, OutputFormat outputFormat, Config params) {
        return new OutputProcessorConfig(name, outputFormat, params);
    }
}

