/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer;

import com.linkedin.feathr.core.config.producer.FeatureDefConfig;
import com.linkedin.feathr.core.config.producer.anchors.AnchorsConfig;
import com.linkedin.feathr.core.config.producer.derivations.DerivationsConfig;
import com.linkedin.feathr.core.config.producer.sources.SourcesConfig;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors.AnchorsConfigBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.derivations.DerivationsConfigBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.sources.SourcesConfigBuilder;
import com.typesafe.config.Config;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FeatureDefConfigBuilder {
    private static final Logger logger = LogManager.getLogger(FeatureDefConfigBuilder.class);

    public static FeatureDefConfig build(Config config) {
        SourcesConfig sources = null;
        if (config.hasPath("sources")) {
            Config sourcesCfg = config.getConfig("sources");
            sources = SourcesConfigBuilder.build(sourcesCfg);
        }
        AnchorsConfig anchors = null;
        if (config.hasPath("anchors")) {
            Config anchorsCfg = config.getConfig("anchors");
            anchors = AnchorsConfigBuilder.build(anchorsCfg);
        }
        DerivationsConfig derivations = null;
        if (config.hasPath("derivations")) {
            Config derivationCfg = config.getConfig("derivations");
            derivations = DerivationsConfigBuilder.build(derivationCfg);
        }
        FeatureDefConfig configObj = new FeatureDefConfig(sources, anchors, derivations);
        logger.debug("Built FeatureDefConfig object");
        return configObj;
    }

    private Boolean validateSemantics(FeatureDefConfig configObj) {
        return true;
    }
}

