/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors;

import com.linkedin.feathr.core.config.producer.anchors.AnchorConfig;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors.AnchorConfigWithExtractorBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors.AnchorConfigWithKeyBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors.AnchorConfigWithKeyExtractorBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors.AnchorConfigWithOnlyMvelBuilder;
import com.typesafe.config.Config;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class AnchorConfigBuilder {
    private static final Logger logger = LogManager.getLogger(AnchorConfigBuilder.class);

    private AnchorConfigBuilder() {
    }

    public static AnchorConfig build(String name, Config config) {
        logger.debug("Building AnchorConfig object for anchor " + name);
        AnchorConfig anchorConfig = config.hasPath("extractor") || config.hasPath("transformer") ? AnchorConfigWithExtractorBuilder.build(name, config) : (config.hasPath("keyExtractor") ? AnchorConfigWithKeyExtractorBuilder.build(name, config) : (config.hasPath("key") ? AnchorConfigWithKeyBuilder.build(name, config) : AnchorConfigWithOnlyMvelBuilder.build(name, config)));
        logger.debug("Built AnchorConfig object for anchor " + name);
        return anchorConfig;
    }
}

