/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors;

import com.linkedin.feathr.core.config.TimeWindowAggregationType;
import com.linkedin.feathr.core.config.WindowType;
import com.linkedin.feathr.core.config.producer.ExprType;
import com.linkedin.feathr.core.config.producer.TypedExpr;
import com.linkedin.feathr.core.config.producer.anchors.TimeWindowFeatureConfig;
import com.linkedin.feathr.core.config.producer.anchors.WindowParametersConfig;
import com.linkedin.feathr.core.config.producer.common.FeatureTypeConfig;
import com.linkedin.feathr.core.configbuilder.ConfigBuilderException;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors.FeatureConfigBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors.WindowParametersConfigBuilder;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.common.FeatureTypeConfigBuilder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueType;
import java.time.Duration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class TimeWindowFeatureConfigBuilder {
    private static final Logger logger = LogManager.getLogger(FeatureConfigBuilder.class);

    private TimeWindowFeatureConfigBuilder() {
    }

    public static TimeWindowFeatureConfig build(String featureName, Config featureConfig) {
        String defType = featureConfig.hasPath("def.mvel") ? "def.mvel" : "def";
        ExprType defExprType = featureConfig.hasPath("def.mvel") ? ExprType.MVEL : ExprType.SQL;
        String columnExpr = featureConfig.getString(defType);
        String aggregationStr = featureConfig.getString("aggregation");
        TimeWindowAggregationType aggregation = TimeWindowAggregationType.valueOf(aggregationStr);
        WindowParametersConfig windowParameters = null;
        if (featureConfig.hasPath("windowParameters")) {
            Config windowsParametersConfig = featureConfig.getConfig("windowParameters");
            windowParameters = WindowParametersConfigBuilder.build(windowsParametersConfig);
        } else if (featureConfig.hasPath("window")) {
            WindowType type = WindowType.SLIDING;
            Duration window = featureConfig.getDuration("window");
            if (window.getSeconds() <= 0L) {
                String errMsg = "window field must be in units of seconds, minutes, hours or days, and must be > 0. Refer to https://github.com/lightbend/config/blob/master/HOCON.md#duration-format for supported unit strings.";
                throw new ConfigBuilderException(errMsg);
            }
            windowParameters = new WindowParametersConfig(type, window, null);
        }
        TypedExpr typedFilter = null;
        if (featureConfig.hasPath("filter.mvel") || featureConfig.hasPath("filter")) {
            ExprType filterExprType = featureConfig.hasPath("filter.mvel") ? ExprType.MVEL : ExprType.SQL;
            String filterType = featureConfig.getValue("filter").valueType() == ConfigValueType.OBJECT ? "filter.mvel" : "filter";
            String filter = featureConfig.getString(filterType);
            typedFilter = new TypedExpr(filter, filterExprType);
        }
        String groupBy = TimeWindowFeatureConfigBuilder.getString(featureConfig, "groupBy");
        Integer limit = TimeWindowFeatureConfigBuilder.getInt(featureConfig, "limit");
        String decay = TimeWindowFeatureConfigBuilder.getString(featureConfig, "decay");
        String weight = TimeWindowFeatureConfigBuilder.getString(featureConfig, "weight");
        Integer embeddingSize = TimeWindowFeatureConfigBuilder.getInt(featureConfig, "embeddingSize");
        FeatureTypeConfig featureTypeConfig = FeatureTypeConfigBuilder.build(featureConfig);
        String defaultValue = featureConfig.hasPath("default") ? featureConfig.getValue("default").unwrapped().toString() : null;
        TimeWindowFeatureConfig configObj = new TimeWindowFeatureConfig(new TypedExpr(columnExpr, defExprType), aggregation, windowParameters, typedFilter, groupBy, limit, decay, weight, embeddingSize, featureTypeConfig, defaultValue);
        logger.trace("Built TimeWindowFeatureConfig object for feature: " + featureName);
        return configObj;
    }

    private static String getString(Config featureConfig, String key) {
        return featureConfig.hasPath(key) ? featureConfig.getString(key) : null;
    }

    private static Integer getInt(Config featureConfig, String key) {
        return featureConfig.hasPath(key) ? Integer.valueOf(featureConfig.getInt(key)) : null;
    }
}

