/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.anchors;

import com.linkedin.feathr.core.config.producer.ExprType;
import com.linkedin.feathr.core.config.producer.anchors.TypedKey;
import com.linkedin.feathr.core.utils.ConfigUtils;
import com.typesafe.config.Config;

class TypedKeyBuilder {
    private static final TypedKeyBuilder INSTANCE = new TypedKeyBuilder();

    private TypedKeyBuilder() {
    }

    public static TypedKeyBuilder getInstance() {
        return INSTANCE;
    }

    TypedKey build(Config config) {
        ExprType keyExprType;
        String keyExprTypeStr;
        if (config.hasPath("key.mvel")) {
            keyExprTypeStr = "key.mvel";
            keyExprType = ExprType.MVEL;
        } else if (config.hasPath("key.sqlExpr")) {
            keyExprTypeStr = "key.sqlExpr";
            keyExprType = ExprType.SQL;
        } else {
            keyExprTypeStr = "key";
            keyExprType = ExprType.MVEL;
        }
        String rawKeyExpr = ConfigUtils.getHoconString(config, keyExprTypeStr);
        return rawKeyExpr == null ? null : new TypedKey(rawKeyExpr, keyExprType);
    }
}

