/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.sources;

import com.linkedin.feathr.core.config.producer.sources.HdfsConfigWithSlidingWindow;
import com.linkedin.feathr.core.config.producer.sources.SlidingWindowAggrConfig;
import com.linkedin.feathr.core.configbuilder.typesafe.producer.sources.SlidingWindowAggrConfigBuilder;
import com.typesafe.config.Config;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class HdfsConfigWithSlidingWindowBuilder {
    private static final Logger logger = LogManager.getLogger(HdfsConfigWithSlidingWindowBuilder.class);

    private HdfsConfigWithSlidingWindowBuilder() {
    }

    public static HdfsConfigWithSlidingWindow build(String sourceName, Config sourceConfig) {
        String path = sourceConfig.getString("location.path");
        String timePartitionPattern = sourceConfig.hasPath("timePartitionPattern") ? sourceConfig.getString("timePartitionPattern") : null;
        SlidingWindowAggrConfig swaConfigObj = SlidingWindowAggrConfigBuilder.build(sourceConfig);
        HdfsConfigWithSlidingWindow configObj = new HdfsConfigWithSlidingWindow(sourceName, path, timePartitionPattern, swaConfigObj);
        logger.trace("Built HdfsConfigWithSlidingWindow object for source " + sourceName);
        return configObj;
    }
}

