/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.sources;

import com.linkedin.feathr.core.config.producer.sources.PinotConfig;
import com.linkedin.feathr.core.configbuilder.ConfigBuilderException;
import com.typesafe.config.Config;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PinotConfigBuilder {
    private static final Logger logger = LogManager.getLogger(PinotConfigBuilder.class);
    private static final String QUERY_ARGUMENT_PLACEHOLDER = "?";

    private PinotConfigBuilder() {
    }

    public static PinotConfig build(String sourceName, Config sourceConfig) {
        PinotConfigBuilder.validate(sourceConfig);
        String resourceName = sourceConfig.getString("resourceName");
        String queryTemplate = sourceConfig.getString("queryTemplate");
        String[] queryArguments = sourceConfig.getStringList("queryArguments").toArray(new String[0]);
        String[] queryKeyColumns = sourceConfig.getStringList("queryKeyColumns").toArray(new String[0]);
        PinotConfig configObj = new PinotConfig(sourceName, resourceName, queryTemplate, queryArguments, queryKeyColumns);
        logger.debug("Built PinotConfig object for source " + sourceName);
        return configObj;
    }

    private static void validate(Config sourceConfig) {
        List queryKeyColumnList = sourceConfig.getStringList("queryKeyColumns");
        if (new HashSet(queryKeyColumnList).size() != queryKeyColumnList.size()) {
            throw new ConfigBuilderException(String.format("Column name in queryKeyColumns [%s] need to be unique", queryKeyColumnList));
        }
        String[] queryKeyColumns = queryKeyColumnList.toArray(new String[0]);
        String queryTemplate = sourceConfig.getString("queryTemplate");
        String[] queryArguments = sourceConfig.getStringList("queryArguments").toArray(new String[0]);
        int placeHolderCnt = StringUtils.countMatches((CharSequence)queryTemplate, (CharSequence)QUERY_ARGUMENT_PLACEHOLDER);
        if (placeHolderCnt != queryArguments.length) {
            throw new ConfigBuilderException(String.format("Arguments count does not match between [%s] and [%s]", queryTemplate, queryArguments));
        }
        int keyBasedArgCnt = Arrays.stream(queryArguments).filter(arg -> PinotConfigBuilder.isArgValFromKey(arg)).toArray().length;
        if (keyBasedArgCnt != queryKeyColumns.length) {
            throw new ConfigBuilderException(String.format("Key based arguments count does not match between [%s] and [%s]", queryArguments, queryKeyColumns));
        }
        Pattern p = Pattern.compile("\\b(?i)(in\\s*\\(\\s*\\?\\s*\\))");
        Matcher matcher = p.matcher(queryTemplate);
        int keyColumnPlaceHolderCnt = 0;
        while (matcher.find()) {
            ++keyColumnPlaceHolderCnt;
        }
        if (keyColumnPlaceHolderCnt != queryKeyColumns.length) {
            throw new ConfigBuilderException(String.format("Please make sure the key based placeholders are always wrapped inside an IN clause [%s] [%s]", queryArguments, queryKeyColumns));
        }
    }

    private static boolean isArgValFromKey(String argExpr) {
        return Pattern.compile(".*key\\[\\d.*\\].*").matcher(argExpr).find();
    }
}

