/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.sources;

import com.linkedin.feathr.core.config.producer.sources.RocksDbConfig;
import com.linkedin.feathr.core.configbuilder.ConfigBuilderException;
import com.typesafe.config.Config;
import javax.lang.model.SourceVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class RocksDbConfigBuilder {
    private static final Logger logger = LogManager.getLogger(RocksDbConfigBuilder.class);

    private RocksDbConfigBuilder() {
    }

    public static RocksDbConfig build(String sourceName, Config sourceConfig) {
        String referenceSource = sourceConfig.getString("referenceSource");
        Boolean extractFeatures = sourceConfig.getBoolean("extractFeatures");
        String encoder = RocksDbConfigBuilder.getCodec(sourceConfig, "encoder");
        String decoder = RocksDbConfigBuilder.getCodec(sourceConfig, "decoder");
        String keyExpr = RocksDbConfigBuilder.getCodec(sourceConfig, "keyExpr");
        RocksDbConfig configObj = new RocksDbConfig(sourceName, referenceSource, extractFeatures, encoder, decoder, keyExpr);
        logger.debug("Built RocksDbConfig object for source" + sourceName);
        return configObj;
    }

    private static String getCodec(Config sourceConfig, String codec) {
        if (sourceConfig.hasPath(codec)) {
            String name = sourceConfig.getString(codec);
            if (SourceVersion.isName(name)) {
                return name;
            }
            throw new ConfigBuilderException("Invalid name for " + codec + " : " + name);
        }
        return null;
    }
}

