/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configbuilder.typesafe.producer.sources;

import com.linkedin.feathr.core.config.producer.sources.SlidingWindowAggrConfig;
import com.linkedin.feathr.core.config.producer.sources.TimeWindowParams;
import com.typesafe.config.Config;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class SlidingWindowAggrConfigBuilder {
    private static final Logger logger = LogManager.getLogger(SlidingWindowAggrConfigBuilder.class);
    private static final String LEGACY_TIMESTAMP_FIELD = "timestamp";
    private static final String LEGACY_TIMESTAMP_FORMAT = "timestamp_format";

    private SlidingWindowAggrConfigBuilder() {
    }

    public static SlidingWindowAggrConfig build(Config sourceConfig) {
        String timestampFormat;
        String timestampField;
        Boolean isTimeSeries = sourceConfig.hasPath("isTimeSeries") && sourceConfig.getBoolean("isTimeSeries");
        Config timeWindowConfig = sourceConfig.getConfig("timeWindowParameters");
        if (timeWindowConfig.hasPath(LEGACY_TIMESTAMP_FIELD)) {
            timestampField = timeWindowConfig.getString(LEGACY_TIMESTAMP_FIELD);
            timestampFormat = timeWindowConfig.getString(LEGACY_TIMESTAMP_FORMAT);
        } else {
            timestampField = timeWindowConfig.getString("timestampColumn");
            timestampFormat = timeWindowConfig.getString("timestampColumnFormat");
        }
        TimeWindowParams timeWindowParams = new TimeWindowParams(timestampField, timestampFormat);
        SlidingWindowAggrConfig configObj = new SlidingWindowAggrConfig(isTimeSeries, timeWindowParams);
        logger.trace("Built SlidingWindowAggrConfig object");
        return configObj;
    }
}

