/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.core.configdataprovider;

import com.linkedin.feathr.core.configdataprovider.BaseConfigDataProvider;
import com.linkedin.feathr.core.configdataprovider.ConfigDataProviderException;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ManifestConfigDataProvider
extends BaseConfigDataProvider {
    private static final Logger logger = LogManager.getLogger(ManifestConfigDataProvider.class);
    private static final String MANIFEST_KEY = "manifest";
    private static final String JAR_KEY = "jar";
    private static final String CONF_KEY = "conf";
    private static final String LOCAL_VALUE = "local";
    private String _manifestResourceName;
    private Config _manifestConfig;
    private List<JarFile> _jarFiles;

    public ManifestConfigDataProvider(String manifestResourceName) {
        Objects.requireNonNull(manifestResourceName, "Manifest resource name can't be null");
        this._manifestResourceName = manifestResourceName;
        this._jarFiles = new ArrayList<JarFile>();
        ConfigRenderOptions renderOptions = ConfigRenderOptions.defaults().setComments(false).setOriginComments(false).setFormatted(true).setJson(true);
        this._manifestConfig = ConfigFactory.parseResources((String)manifestResourceName);
        logger.debug("Manifest config: \n" + this._manifestConfig.root().render(renderOptions.setJson(false)));
    }

    @Override
    public List<Reader> getConfigDataReaders() {
        List jarConfConfigList = this._manifestConfig.getConfigList(MANIFEST_KEY);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        for (Config jarConfConfig : jarConfConfigList) {
            String jarFileName = jarConfConfig.getString(JAR_KEY);
            List confFileNames = jarConfConfig.getStringList(CONF_KEY);
            if (jarFileName.equalsIgnoreCase(LOCAL_VALUE)) {
                this.createReaders(loader, confFileNames, this._readers);
                continue;
            }
            this.createReaders(loader, jarFileName, confFileNames, this._readers);
        }
        return this._readers;
    }

    @Override
    public String getConfigDataInfo() {
        return "Manifest: " + this._manifestResourceName;
    }

    @Override
    public void close() {
        super.close();
        try {
            for (JarFile jf : this._jarFiles) {
                jf.close();
            }
        }
        catch (IOException e) {
            logger.warn("Unable to close a jar file");
        }
        logger.debug("Closed " + this._jarFiles.size() + " jar files");
        this._jarFiles.clear();
    }

    private void createReaders(ClassLoader loader, List<String> confFileNames, List<Reader> readers) {
        for (String resName : confFileNames) {
            InputStream in = loader.getResourceAsStream(resName);
            if (in == null) {
                throw new ConfigDataProviderException("Config file " + resName + " can't be obtained as an input stream");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            readers.add(0, reader);
        }
    }

    private void createReaders(ClassLoader loader, String jarFileName, List<String> confFileNames, List<Reader> readers) {
        URL jarFileUrl = loader.getResource(jarFileName);
        if (jarFileUrl == null) {
            throw new ConfigDataProviderException("Unable to load jar file " + jarFileName);
        }
        String jarFilePath = jarFileUrl.getPath();
        try {
            JarFile jarFile = new JarFile(jarFilePath);
            this._jarFiles.add(jarFile);
            for (String confFileName : confFileNames) {
                JarEntry entry = jarFile.getJarEntry(confFileName);
                InputStream inStream = jarFile.getInputStream(entry);
                InputStreamReader inStreamReader = new InputStreamReader(inStream);
                BufferedReader reader = new BufferedReader(inStreamReader);
                readers.add(reader);
            }
        }
        catch (Exception e) {
            throw new ConfigDataProviderException("Error in creating config file readers from jar " + jarFileName, e);
        }
    }
}

